/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class ObservableDistinct<T, K>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Callable<? extends Predicate<? super K>> predicateSupplier;

    public ObservableDistinct(ObservableSource<T> source, Function<? super T, K> keySelector, Callable<? extends Predicate<? super K>> predicateSupplier) {
        super(source);
        this.predicateSupplier = predicateSupplier;
        this.keySelector = keySelector;
    }

    public static <T, K> ObservableDistinct<T, K> withCollection(ObservableSource<T> source, Function<? super T, K> keySelector, final Callable<? extends Collection<? super K>> collectionSupplier) {
        Callable p = new Callable<Predicate<K>>(){

            @Override
            public Predicate<K> call() throws Exception {
                final Collection coll = (Collection)collectionSupplier.call();
                return new Predicate<K>(){

                    @Override
                    public boolean test(K t) {
                        if (t == null) {
                            coll.clear();
                            return true;
                        }
                        return coll.add(t);
                    }
                };
            }
        };
        return new ObservableDistinct<T, K>(source, keySelector, p);
    }

    public static <T> ObservableDistinct<T, T> untilChanged(ObservableSource<T> source) {
        Callable p = new Callable<Predicate<T>>(){

            @Override
            public Predicate<T> call() {
                final Object[] last = new Object[]{null};
                return new Predicate<T>(){

                    @Override
                    public boolean test(T t) {
                        if (t == null) {
                            last[0] = null;
                            return true;
                        }
                        Object o = last[0];
                        last[0] = t;
                        return !ObjectHelper.equals(o, t);
                    }
                };
            }
        };
        return new ObservableDistinct(source, Functions.identity(), p);
    }

    public static <T, K> ObservableDistinct<T, K> untilChanged(ObservableSource<T> source, Function<? super T, K> keySelector) {
        Callable p = new Callable<Predicate<K>>(){

            @Override
            public Predicate<K> call() {
                final Object[] last = new Object[]{null};
                return new Predicate<K>(){

                    @Override
                    public boolean test(K t) {
                        if (t == null) {
                            last[0] = null;
                            return true;
                        }
                        Object o = last[0];
                        last[0] = t;
                        return !ObjectHelper.equals(o, t);
                    }
                };
            }
        };
        return new ObservableDistinct<T, K>(source, keySelector, p);
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        Predicate<? super K> coll;
        try {
            coll = this.predicateSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (coll == null) {
            EmptyDisposable.error((Throwable)new NullPointerException("predicateSupplier returned null"), t);
            return;
        }
        this.source.subscribe(new DistinctSubscriber<T, K>(t, this.keySelector, coll));
    }

    static final class DistinctSubscriber<T, K>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final Predicate<? super K> predicate;
        final Function<? super T, K> keySelector;
        Disposable s;

        public DistinctSubscriber(Observer<? super T> actual, Function<? super T, K> keySelector, Predicate<? super K> predicate) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            boolean b;
            K key;
            try {
                key = this.keySelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.actual.onError(e);
                return;
            }
            if (key == null) {
                this.s.dispose();
                this.actual.onError(new NullPointerException("Null key supplied"));
                return;
            }
            try {
                b = this.predicate.test(key);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.actual.onError(e);
                return;
            }
            if (b) {
                this.actual.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.predicate.test(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(e, t));
                return;
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            try {
                this.predicate.test(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            this.actual.onComplete();
        }
    }
}

