/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCombineLatest<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super T[], ? extends R> combiner;
    final int bufferSize;
    final boolean delayError;

    public ObservableCombineLatest(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super T[], ? extends R> combiner, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> s) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Observable[8];
            for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                if (count == sources.length) {
                    ObservableSource[] b = new ObservableSource[count + (count >> 2)];
                    System.arraycopy(sources, 0, b, 0, count);
                    sources = b;
                }
                sources[count++] = observableSource;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(s);
            return;
        }
        LatestCoordinator<? extends T, R> lc = new LatestCoordinator<T, R>(s, this.combiner, count, this.bufferSize, this.delayError);
        lc.subscribe(sources);
    }

    static final class CombinerSubscriber<T, R>
    implements Observer<T>,
    Disposable {
        final LatestCoordinator<T, R> parent;
        final int index;
        boolean done;
        final AtomicReference<Disposable> s = new AtomicReference();

        public CombinerSubscriber(LatestCoordinator<T, R> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this.s, s);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.parent.combine(t, this.index);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.parent.onError(t);
            this.done = true;
            this.parent.combine(null, this.index);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.combine(null, this.index);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.s);
        }

        @Override
        public boolean isDisposed() {
            return this.s.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class LatestCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 8567835998786448817L;
        final Observer<? super R> actual;
        final Function<? super T[], ? extends R> combiner;
        final int count;
        final CombinerSubscriber<T, R>[] subscribers;
        final int bufferSize;
        final T[] latest;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        volatile boolean cancelled;
        volatile boolean done;
        final AtomicReference<Throwable> error = new AtomicReference();
        int active;
        int complete;

        public LatestCoordinator(Observer<? super R> actual, Function<? super T[], ? extends R> combiner, int count, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.combiner = combiner;
            this.count = count;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.latest = new Object[count];
            this.subscribers = new CombinerSubscriber[count];
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        public void subscribe(ObservableSource<? extends T>[] sources) {
            int i;
            CombinerSubscriber<T, R>[] as = this.subscribers;
            int len = as.length;
            for (i = 0; i < len; ++i) {
                as[i] = new CombinerSubscriber(this, i);
            }
            this.lazySet(0);
            this.actual.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.cancelled) {
                    return;
                }
                sources[i].subscribe(as[i]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.cancel(this.queue);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel(SpscLinkedArrayQueue<?> q) {
            this.clear(q);
            for (CombinerSubscriber<T, R> s : this.subscribers) {
                s.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(SpscLinkedArrayQueue<?> q) {
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                Arrays.fill(this.latest, null);
            }
            q.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void combine(T value, int index) {
            boolean f;
            CombinerSubscriber<T, R> cs = this.subscribers[index];
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                boolean empty;
                if (this.cancelled) {
                    return;
                }
                int len = this.latest.length;
                T o = this.latest[index];
                int a = this.active;
                if (o == null) {
                    this.active = ++a;
                }
                int c = this.complete;
                if (value == null) {
                    this.complete = ++c;
                } else {
                    this.latest[index] = value;
                }
                f = a == len;
                boolean bl = empty = c == len || value == null && o == null;
                if (!empty) {
                    if (value != null && f) {
                        this.queue.offer(cs, this.latest.clone());
                    } else if (value == null && this.error.get() != null) {
                        this.done = true;
                    }
                } else {
                    this.done = true;
                }
            }
            if (!f && value != null) {
                return;
            }
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SpscLinkedArrayQueue<Object> q = this.queue;
            Observer<R> a = this.actual;
            boolean delayError = this.delayError;
            int missed = 1;
            block2: do {
                if (this.checkTerminated(this.done, q.isEmpty(), a, q, delayError)) {
                    return;
                }
                while (true) {
                    R v;
                    boolean empty;
                    boolean d = this.done;
                    CombinerSubscriber cs = (CombinerSubscriber)q.poll();
                    boolean bl = empty = cs == null;
                    if (this.checkTerminated(d, empty, a, q, delayError)) {
                        return;
                    }
                    if (empty) continue block2;
                    Object[] array = (Object[])q.poll();
                    if (array == null) {
                        this.cancelled = true;
                        this.cancel(q);
                        a.onError(new IllegalStateException("Broken queue?! Sender received but not the array."));
                        return;
                    }
                    try {
                        v = this.combiner.apply(array);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.cancel(q);
                        a.onError(ex);
                        return;
                    }
                    if (v == null) {
                        this.cancelled = true;
                        this.cancel(q);
                        a.onError(new NullPointerException("The combiner returned a null"));
                        return;
                    }
                    a.onNext(v);
                }
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Observer<?> a, SpscLinkedArrayQueue<?> q, boolean delayError) {
            if (this.cancelled) {
                this.cancel(q);
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        this.clear(this.queue);
                        Throwable e = this.error.get();
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error.get();
                    if (e != null) {
                        this.cancel(q);
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        this.clear(this.queue);
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        void onError(Throwable e) {
            Throwable next;
            Throwable curr;
            do {
                if (!((curr = this.error.get()) instanceof CompositeException)) continue;
                CompositeException ce = new CompositeException(new Throwable[]{(CompositeException)curr});
                ce.suppress(e);
                e = ce;
            } while (!this.error.compareAndSet(curr, next = e));
        }
    }
}

