/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableOperator;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableLift<R, T>
extends AbstractFlowableWithUpstream<T, R> {
    final FlowableOperator<? extends R, ? super T> operator;

    public FlowableLift(Publisher<T> source, FlowableOperator<? extends R, ? super T> operator) {
        super(source);
        this.operator = operator;
    }

    public FlowableOperator<? extends R, ? super T> operator() {
        return this.operator;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        try {
            if (s == null) {
                throw new NullPointerException("Operator " + this.operator + " received a null Subscriber");
            }
            Subscriber st = (Subscriber)this.operator.apply(s);
            if (st == null) {
                throw new NullPointerException("Operator " + this.operator + " returned a null Subscriber");
            }
            this.source.subscribe(st);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }
}

