/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.subscribers.flowable.BlockingSubscriber;
import io.reactivex.internal.subscribers.flowable.LambdaSubscriber;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subscribers.DefaultSubscriber;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public enum FlowableBlockingSubscribe {


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> void subscribe(Publisher<? extends T> o, Subscriber<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs = new BlockingSubscriber((Queue<Object>)queue);
        o.subscribe(bs);
        try {
            Object v;
            do {
                if (bs.isCancelled()) {
                    return;
                }
                v = queue.poll();
                if (v == null) {
                    if (bs.isCancelled()) {
                        return;
                    }
                    v = queue.take();
                }
                if (bs.isCancelled()) {
                    return;
                }
                if (o != BlockingSubscriber.TERMINATED) continue;
                return;
            } while (!NotificationLite.acceptFull(v, subscriber));
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            subscriber.onError((Throwable)e);
            return;
        }
        finally {
            bs.cancel();
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o) {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] error = new Throwable[]{null};
        LambdaSubscriber ls = new LambdaSubscriber(Functions.emptyConsumer(), (Consumer<? super Throwable>)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable e) {
                error[0] = e;
                cdl.countDown();
            }
        }, new Action(){

            @Override
            public void run() {
                cdl.countDown();
            }
        }, (Consumer<? super Subscription>)new Consumer<Subscription>(){

            @Override
            public void accept(Subscription s) {
                s.request(Long.MAX_VALUE);
            }
        });
        o.subscribe(ls);
        BlockingHelper.awaitForComplete(cdl, ls);
        Throwable e = error[0];
        if (e != null) {
            throw Exceptions.propagate(e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o, final Consumer<? super T> onNext, final Consumer<? super Throwable> onError, final Action onComplete) {
        FlowableBlockingSubscribe.subscribe(o, new DefaultSubscriber<T>(){
            boolean done;

            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                try {
                    onNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                }
            }

            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                this.done = true;
                try {
                    onError.accept(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                try {
                    onComplete.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        });
    }
}

