/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableMerge
extends Completable {
    final Publisher<? extends CompletableSource> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableMerge(Publisher<? extends CompletableSource> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(s, this.maxConcurrency, this.delayErrors);
        this.source.subscribe((Subscriber)parent);
    }

    public static Throwable collectErrors(SimpleQueue<Throwable> q) {
        CompositeException composite = null;
        Throwable first = null;
        int count = 0;
        while (true) {
            Throwable t;
            try {
                t = q.poll();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (composite == null) {
                    composite = new CompositeException(new Throwable[]{first});
                }
                composite.suppress(ex);
                break;
            }
            if (t == null) break;
            if (count == 0) {
                first = t;
            } else {
                if (composite == null) {
                    composite = new CompositeException(new Throwable[]{first});
                }
                composite.suppress(t);
            }
            ++count;
        }
        if (composite != null) {
            return composite;
        }
        return first;
    }

    static final class CompletableMergeSubscriber
    extends AtomicInteger
    implements Subscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = -2108443387387077490L;
        final CompletableObserver actual;
        final CompositeDisposable set;
        final int maxConcurrency;
        final boolean delayErrors;
        Subscription s;
        volatile boolean done;
        final AtomicReference<SimpleQueue<Throwable>> errors = new AtomicReference();
        final AtomicBoolean once = new AtomicBoolean();

        public CompletableMergeSubscriber(CompletableObserver actual, int maxConcurrency, boolean delayErrors) {
            this.actual = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.set.add(Disposables.from(s));
                this.actual.onSubscribe(this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request((long)this.maxConcurrency);
                }
            }
        }

        SimpleQueue<Throwable> getOrCreateErrors() {
            SimpleQueue<Throwable> q = this.errors.get();
            if (q != null) {
                return q;
            }
            q = new MpscLinkedQueue<Throwable>();
            if (this.errors.compareAndSet(null, q)) {
                return q;
            }
            return this.errors.get();
        }

        public void onNext(CompletableSource t) {
            if (this.done) {
                return;
            }
            this.getAndIncrement();
            t.subscribe(new CompletableObserver(){
                Disposable d;
                boolean innerDone;

                @Override
                public void onSubscribe(Disposable d) {
                    this.d = d;
                    CompletableMergeSubscriber.this.set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    if (this.innerDone) {
                        RxJavaPlugins.onError(e);
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.getOrCreateErrors().offer(e);
                    CompletableMergeSubscriber.this.terminate();
                    if (CompletableMergeSubscriber.this.delayErrors && !CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.s.request(1L);
                    }
                }

                @Override
                public void onComplete() {
                    if (this.innerDone) {
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.terminate();
                    if (!CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.s.request(1L);
                    }
                }
            });
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.getOrCreateErrors().offer(t);
            this.done = true;
            this.terminate();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.terminate();
        }

        void terminate() {
            SimpleQueue<Throwable> q;
            if (this.decrementAndGet() == 0) {
                SimpleQueue<Throwable> q2 = this.errors.get();
                if (q2 == null || q2.isEmpty()) {
                    this.actual.onComplete();
                } else {
                    Throwable e = CompletableMerge.collectErrors(q2);
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onError(e);
                    } else {
                        RxJavaPlugins.onError(e);
                    }
                }
            } else if (!this.delayErrors && (q = this.errors.get()) != null && !q.isEmpty()) {
                Throwable e = CompletableMerge.collectErrors(q);
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
            }
        }
    }
}

