/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableConcat
extends Completable {
    final Publisher<? extends CompletableSource> sources;
    final int prefetch;

    public CompletableConcat(Publisher<? extends CompletableSource> sources, int prefetch) {
        this.sources = sources;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompletableConcatSubscriber parent = new CompletableConcatSubscriber(s, this.prefetch);
        this.sources.subscribe((Subscriber)parent);
    }

    static final class CompletableConcatSubscriber
    extends AtomicInteger
    implements Subscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = 7412667182931235013L;
        final CompletableObserver actual;
        final int prefetch;
        final SequentialDisposable sd;
        final SpscArrayQueue<CompletableSource> queue;
        Subscription s;
        volatile boolean done;
        final AtomicBoolean once = new AtomicBoolean();
        final ConcatInnerObserver inner;

        public CompletableConcatSubscriber(CompletableObserver actual, int prefetch) {
            this.actual = actual;
            this.prefetch = prefetch;
            this.queue = new SpscArrayQueue(prefetch);
            this.sd = new SequentialDisposable();
            this.inner = new ConcatInnerObserver();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(CompletableSource t) {
            if (!this.queue.offer(t)) {
                this.onError(new MissingBackpressureException());
                return;
            }
            if (this.getAndIncrement() == 0) {
                this.next();
            }
        }

        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(t);
                return;
            }
            RxJavaPlugins.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.getAndIncrement() == 0) {
                this.next();
            }
        }

        void innerError(Throwable e) {
            this.s.cancel();
            this.onError(e);
        }

        void innerComplete() {
            if (this.decrementAndGet() != 0) {
                this.next();
            }
            if (!this.done) {
                this.s.request(1L);
            }
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.sd.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.sd.isDisposed();
        }

        void next() {
            boolean d = this.done;
            CompletableSource c = this.queue.poll();
            if (c == null) {
                if (d) {
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onComplete();
                    }
                    return;
                }
                RxJavaPlugins.onError(new IllegalStateException("Queue is empty?!"));
                return;
            }
            c.subscribe(this.inner);
        }

        final class ConcatInnerObserver
        implements CompletableObserver {
            ConcatInnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                CompletableConcatSubscriber.this.sd.update(d);
            }

            @Override
            public void onError(Throwable e) {
                CompletableConcatSubscriber.this.innerError(e);
            }

            @Override
            public void onComplete() {
                CompletableConcatSubscriber.this.innerComplete();
            }
        }
    }
}

