/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableAmbIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableAmbIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s) {
        Iterator<? extends CompletableSource> it;
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        try {
            it = this.sources.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onError(e);
            return;
        }
        if (it == null) {
            s.onError(new NullPointerException("The iterator returned is null"));
            return;
        }
        boolean empty = true;
        final AtomicBoolean once = new AtomicBoolean();
        CompletableObserver inner = new CompletableObserver(){

            @Override
            public void onComplete() {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onComplete();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
            }

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
            }
        };
        while (true) {
            CompletableSource c;
            boolean b;
            if (once.get() || set.isDisposed()) {
                return;
            }
            try {
                b = it.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            if (!b) {
                if (!empty) break;
                s.onComplete();
                break;
            }
            empty = false;
            if (once.get() || set.isDisposed()) {
                return;
            }
            try {
                c = it.next();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            if (c == null) {
                NullPointerException npe = new NullPointerException("One of the sources is null");
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(npe);
                } else {
                    RxJavaPlugins.onError(npe);
                }
                return;
            }
            if (once.get() || set.isDisposed()) {
                return;
            }
            c.subscribe(inner);
        }
    }
}

