/**
 * Copyright 2016 Netflix, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License.
 */

package io.reactivex.exceptions;

/**
 * Indicates that an operator attempted to emit a value but the downstream wasn't ready for it.
 */
public class MissingBackpressureException extends RuntimeException {
    /** */
    private static final long serialVersionUID = 8517344746016032542L;

    /**
     * Constructs a MissingBackpressureException without message or cause.
     */
    public MissingBackpressureException() {
        super();
    }
    
    /**
     * Constructs a MissingBackpressureException with the given message but no cause.
     * @param message the error message
     */
    public MissingBackpressureException(String message) {
        super(message);
    }
    
    /**
     * Constructs a MissingBackpressureException with the given message and cause.
     * @param message the error message
     * @param cause the cause Throwable
     */
    public MissingBackpressureException(String message, Throwable cause) {
        super(message, cause);
    }
}
