/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.BufferUntilSubscriber;
import rx.subscriptions.Subscriptions;

public final class OperatorWindowWithSize<T>
implements Observable.Operator<Observable<T>, T> {
    final int size;
    final int skip;

    public OperatorWindowWithSize(int size, int skip) {
        this.size = size;
        this.skip = skip;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        if (this.skip == this.size) {
            ExactSubscriber e = new ExactSubscriber(child);
            e.init();
            return e;
        }
        InexactSubscriber ie = new InexactSubscriber(child);
        ie.init();
        return ie;
    }

    static final class CountedSubject<T> {
        final Observer<T> consumer;
        final Observable<T> producer;
        int count;

        public CountedSubject(Observer<T> consumer, Observable<T> producer) {
            this.consumer = consumer;
            this.producer = producer;
        }
    }

    final class InexactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        int count;
        final List<CountedSubject<T>> chunks = new LinkedList();
        volatile boolean noWindow = true;

        public InexactSubscriber(Subscriber<? super Observable<T>> child) {
            this.child = child;
        }

        void init() {
            this.child.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    if (InexactSubscriber.this.noWindow) {
                        InexactSubscriber.this.unsubscribe();
                    }
                }
            }));
            this.child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        long u = n * (long)OperatorWindowWithSize.this.size;
                        if (u >>> 31 != 0L && u / n != (long)OperatorWindowWithSize.this.size) {
                            u = Long.MAX_VALUE;
                        }
                        InexactSubscriber.this.requestMore(u);
                    }
                }
            });
        }

        void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onNext(T t) {
            if (this.count++ % OperatorWindowWithSize.this.skip == 0 && !this.child.isUnsubscribed()) {
                if (this.chunks.isEmpty()) {
                    this.noWindow = false;
                }
                CountedSubject cs = this.createCountedSubject();
                this.chunks.add(cs);
                this.child.onNext(cs.producer);
            }
            Iterator it = this.chunks.iterator();
            while (it.hasNext()) {
                CountedSubject cs = it.next();
                cs.consumer.onNext(t);
                if (++cs.count != OperatorWindowWithSize.this.size) continue;
                it.remove();
                cs.consumer.onCompleted();
            }
            if (this.chunks.isEmpty()) {
                this.noWindow = true;
                if (this.child.isUnsubscribed()) {
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            ArrayList list = new ArrayList(this.chunks);
            this.chunks.clear();
            this.noWindow = true;
            for (CountedSubject countedSubject : list) {
                countedSubject.consumer.onError(e);
            }
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            ArrayList list = new ArrayList(this.chunks);
            this.chunks.clear();
            this.noWindow = true;
            for (CountedSubject countedSubject : list) {
                countedSubject.consumer.onCompleted();
            }
            this.child.onCompleted();
        }

        CountedSubject<T> createCountedSubject() {
            BufferUntilSubscriber bus = BufferUntilSubscriber.create();
            return new CountedSubject(bus, bus);
        }
    }

    final class ExactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        int count;
        BufferUntilSubscriber<T> window;
        volatile boolean noWindow = true;

        public ExactSubscriber(Subscriber<? super Observable<T>> child) {
            this.child = child;
        }

        void init() {
            this.child.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    if (ExactSubscriber.this.noWindow) {
                        ExactSubscriber.this.unsubscribe();
                    }
                }
            }));
            this.child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        long u = n * (long)OperatorWindowWithSize.this.size;
                        if (u >>> 31 != 0L && u / n != (long)OperatorWindowWithSize.this.size) {
                            u = Long.MAX_VALUE;
                        }
                        ExactSubscriber.this.requestMore(u);
                    }
                }
            });
        }

        void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onNext(T t) {
            if (this.window == null) {
                this.noWindow = false;
                this.window = BufferUntilSubscriber.create();
                this.child.onNext(this.window);
            }
            this.window.onNext(t);
            if (++this.count % OperatorWindowWithSize.this.size == 0) {
                this.window.onCompleted();
                this.window = null;
                this.noWindow = true;
                if (this.child.isUnsubscribed()) {
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.window != null) {
                this.window.onError(e);
            }
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.window != null) {
                this.window.onCompleted();
            }
            this.child.onCompleted();
        }
    }
}

