/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Subscription;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.CompositeSubscription;

public final class ScheduledAction
implements Runnable,
Subscription {
    final CompositeSubscription cancel;
    final Action0 action;
    volatile int once;
    static final AtomicIntegerFieldUpdater<ScheduledAction> ONCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ScheduledAction.class, "once");

    public ScheduledAction(Action0 action) {
        this.action = action;
        this.cancel = new CompositeSubscription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.action.call();
        }
        catch (Throwable e) {
            IllegalStateException ie = null;
            ie = e instanceof OnErrorNotImplementedException ? new IllegalStateException("Exception thrown on Scheduler.Worker thread. Add `onError` handling.", e) : new IllegalStateException("Fatal Exception thrown on Scheduler.Worker thread.", e);
            ie.printStackTrace();
            RxJavaPlugins.getInstance().getErrorHandler().handleError(ie);
        }
        finally {
            this.unsubscribe();
        }
    }

    @Override
    public boolean isUnsubscribed() {
        return this.cancel.isUnsubscribed();
    }

    @Override
    public void unsubscribe() {
        if (ONCE_UPDATER.compareAndSet(this, 0, 1)) {
            this.cancel.unsubscribe();
        }
    }

    public void add(Subscription s) {
        this.cancel.add(s);
    }

    public void addParent(CompositeSubscription parent) {
        this.cancel.add(new Remover(this, parent));
    }

    private static final class Remover
    implements Subscription {
        final Subscription s;
        final CompositeSubscription parent;
        volatile int once;
        static final AtomicIntegerFieldUpdater<Remover> ONCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Remover.class, "once");

        public Remover(Subscription s, CompositeSubscription parent) {
            this.s = s;
            this.parent = parent;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.s.isUnsubscribed();
        }

        @Override
        public void unsubscribe() {
            if (ONCE_UPDATER.compareAndSet(this, 0, 1)) {
                this.parent.remove(this.s);
            }
        }
    }
}

