/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;

public class OperatorOnBackpressureBuffer<T>
implements Observable.Operator<T, T> {
    private final NotificationLite<T> on = NotificationLite.instance();

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        final AtomicLong wip = new AtomicLong();
        final AtomicLong requested = new AtomicLong();
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (requested.getAndAdd(n) == 0L) {
                    OperatorOnBackpressureBuffer.this.pollQueue(wip, requested, queue, child);
                }
            }
        });
        Subscriber parent = new Subscriber<T>(){

            @Override
            public void onCompleted() {
                queue.offer(OperatorOnBackpressureBuffer.this.on.completed());
                OperatorOnBackpressureBuffer.this.pollQueue(wip, requested, queue, child);
            }

            @Override
            public void onError(Throwable e) {
                queue.offer(OperatorOnBackpressureBuffer.this.on.error(e));
                OperatorOnBackpressureBuffer.this.pollQueue(wip, requested, queue, child);
            }

            @Override
            public void onNext(T t) {
                queue.offer(OperatorOnBackpressureBuffer.this.on.next(t));
                OperatorOnBackpressureBuffer.this.pollQueue(wip, requested, queue, child);
            }
        };
        child.add(parent);
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollQueue(AtomicLong wip, AtomicLong requested, Queue<Object> queue, Subscriber<? super T> child) {
        if (requested.get() > 0L) {
            try {
                if (wip.getAndIncrement() == 0L) {
                    while (requested.getAndDecrement() != 0L) {
                        Object o = queue.poll();
                        if (o == null) {
                            requested.incrementAndGet();
                            return;
                        }
                        this.on.accept(child, o);
                    }
                    requested.incrementAndGet();
                    return;
                }
            }
            finally {
                wip.decrementAndGet();
            }
        }
    }
}

