/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import rx.internal.util.RxThreadFactory;

final class GenericScheduledExecutorService {
    private static final String THREAD_NAME_PREFIX = "RxScheduledExecutorPool-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("RxScheduledExecutorPool-");
    private static final GenericScheduledExecutorService INSTANCE = new GenericScheduledExecutorService();
    private final ScheduledExecutorService executor;

    private GenericScheduledExecutorService() {
        int count = Runtime.getRuntime().availableProcessors();
        if (count > 4) {
            count /= 2;
        }
        if (count > 8) {
            count = 8;
        }
        this.executor = Executors.newScheduledThreadPool(count, THREAD_FACTORY);
    }

    public static ScheduledExecutorService getInstance() {
        return GenericScheduledExecutorService.INSTANCE.executor;
    }
}

