/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func2;

public final class OperatorScan<R, T>
implements Observable.Operator<R, T> {
    private final R initialValue;
    private final Func2<R, ? super T, R> accumulator;
    private static final Object NO_INITIAL_VALUE = new Object();

    public OperatorScan(R initialValue, Func2<R, ? super T, R> accumulator) {
        this.initialValue = initialValue;
        this.accumulator = accumulator;
    }

    public OperatorScan(Func2<R, ? super T, R> accumulator) {
        this(NO_INITIAL_VALUE, accumulator);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> child) {
        return new Subscriber<T>(child){
            private R value;
            boolean initialized;
            {
                super(x0);
                this.value = OperatorScan.this.initialValue;
                this.initialized = false;
            }

            @Override
            public void onNext(T currentValue) {
                this.emitInitialValueIfNeeded(child);
                if (this.value == NO_INITIAL_VALUE) {
                    this.value = currentValue;
                } else {
                    try {
                        this.value = OperatorScan.this.accumulator.call(this.value, currentValue);
                    }
                    catch (Throwable e) {
                        child.onError(OnErrorThrowable.addValueAsLastCause(e, currentValue));
                    }
                }
                child.onNext(this.value);
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                this.emitInitialValueIfNeeded(child);
                child.onCompleted();
            }

            private void emitInitialValueIfNeeded(Subscriber<? super R> child2) {
                if (!this.initialized) {
                    this.initialized = true;
                    if (OperatorScan.this.initialValue != NO_INITIAL_VALUE) {
                        child2.onNext(OperatorScan.this.initialValue);
                    }
                }
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){
                    final AtomicBoolean once = new AtomicBoolean();

                    @Override
                    public void request(long n) {
                        if (this.once.compareAndSet(false, true)) {
                            if (OperatorScan.this.initialValue == NO_INITIAL_VALUE) {
                                producer.request(n);
                            } else {
                                producer.request(n - 1L);
                            }
                        } else {
                            producer.request(n);
                        }
                    }
                });
            }
        };
    }
}

