/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.functions.Func1;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnErrorReturn<T>
implements Observable.Operator<T, T> {
    final Func1<Throwable, ? extends T> resultFunction;

    public OperatorOnErrorReturn(Func1<Throwable, ? extends T> resultFunction) {
        this.resultFunction = resultFunction;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    Object result = OperatorOnErrorReturn.this.resultFunction.call(e);
                    child.onNext(result);
                }
                catch (Throwable x) {
                    child.onError(new CompositeException(Arrays.asList(e, x)));
                    return;
                }
                child.onCompleted();
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }
}

