/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;
import rx.subscriptions.SerialSubscription;

public final class OnSubscribeRedo<T>
implements Observable.OnSubscribe<T> {
    static final Func1<Observable<? extends Notification<?>>, Observable<?>> REDO_INIFINITE = new Func1<Observable<? extends Notification<?>>, Observable<?>>(){

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){

                @Override
                public Notification<?> call(Notification<?> terminal) {
                    return Notification.createOnNext(null);
                }
            });
        }
    };
    private Observable<T> source;
    private final Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> controlHandlerFunction;
    private boolean stopOnComplete;
    private boolean stopOnError;
    private final Scheduler scheduler;

    public static <T> Observable<T> retry(Observable<T> source) {
        return OnSubscribeRedo.retry(source, REDO_INIFINITE);
    }

    public static <T> Observable<T> retry(Observable<T> source, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        if (count == 0L) {
            return source;
        }
        return OnSubscribeRedo.retry(source, new RedoFinite(count));
    }

    public static <T> Observable<T> retry(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, true, false, Schedulers.trampoline()));
    }

    public static <T> Observable<T> retry(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, true, false, scheduler));
    }

    public static <T> Observable<T> repeat(Observable<T> source) {
        return OnSubscribeRedo.repeat(source, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source, Scheduler scheduler) {
        return OnSubscribeRedo.repeat(source, REDO_INIFINITE, scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source, long count) {
        return OnSubscribeRedo.repeat(source, count, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source, long count, Scheduler scheduler) {
        if (count == 0L) {
            return Observable.empty();
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        return OnSubscribeRedo.repeat(source, new RedoFinite(count - 1L), scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, true, Schedulers.trampoline()));
    }

    public static <T> Observable<T> repeat(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, true, scheduler));
    }

    public static <T> Observable<T> redo(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, false, scheduler));
    }

    private OnSubscribeRedo(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> f, boolean stopOnComplete, boolean stopOnError, Scheduler scheduler) {
        this.source = source;
        this.controlHandlerFunction = f;
        this.stopOnComplete = stopOnComplete;
        this.stopOnError = stopOnError;
        this.scheduler = scheduler;
    }

    @Override
    public void call(final Subscriber<? super T> child) {
        final AtomicBoolean isLocked = new AtomicBoolean(true);
        final AtomicBoolean isStarted = new AtomicBoolean(false);
        final AtomicLong consumerCapacity = new AtomicLong(0L);
        final AtomicReference currentProducer = new AtomicReference();
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        final SerialSubscription sourceSubscriptions = new SerialSubscription();
        child.add(sourceSubscriptions);
        final PublishSubject terminals = PublishSubject.create();
        final Action0 subscribeToSource = new Action0(){

            @Override
            public void call() {
                Subscriber terminalDelegatingSubscriber = new Subscriber<T>(){

                    @Override
                    public void onCompleted() {
                        this.unsubscribe();
                        terminals.onNext(Notification.createOnCompleted());
                    }

                    @Override
                    public void onError(Throwable e) {
                        this.unsubscribe();
                        terminals.onNext(Notification.createOnError(e));
                    }

                    @Override
                    public void onNext(T v) {
                        consumerCapacity.decrementAndGet();
                        child.onNext(v);
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        currentProducer.set(producer);
                        producer.request(consumerCapacity.get());
                    }
                };
                sourceSubscriptions.set(terminalDelegatingSubscriber);
                OnSubscribeRedo.this.source.unsafeSubscribe(terminalDelegatingSubscriber);
            }
        };
        final Observable<?> restarts = this.controlHandlerFunction.call(terminals.lift(new Observable.Operator<Notification<?>, Notification<?>>(){

            @Override
            public Subscriber<? super Notification<?>> call(final Subscriber<? super Notification<?>> filteredTerminals) {
                return new Subscriber<Notification<?>>(filteredTerminals){

                    @Override
                    public void onCompleted() {
                        filteredTerminals.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        filteredTerminals.onError(e);
                    }

                    @Override
                    public void onNext(Notification<?> t) {
                        if (t.isOnCompleted() && OnSubscribeRedo.this.stopOnComplete) {
                            child.onCompleted();
                        } else if (t.isOnError() && OnSubscribeRedo.this.stopOnError) {
                            child.onError(t.getThrowable());
                        } else {
                            isLocked.set(false);
                            filteredTerminals.onNext(t);
                        }
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                };
            }
        }));
        worker.schedule(new Action0(){

            @Override
            public void call() {
                restarts.unsafeSubscribe(new Subscriber<Object>(child){

                    @Override
                    public void onCompleted() {
                        child.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        child.onError(e);
                    }

                    @Override
                    public void onNext(Object t) {
                        if (!isLocked.get() && !child.isUnsubscribed() && consumerCapacity.get() > 0L) {
                            worker.schedule(subscribeToSource);
                        }
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                });
            }
        });
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (isStarted.compareAndSet(false, true)) {
                    consumerCapacity.set(n);
                    worker.schedule(subscribeToSource);
                } else if (consumerCapacity.getAndAdd(n) == 0L) {
                    worker.schedule(subscribeToSource);
                } else if (currentProducer.get() != null) {
                    ((Producer)currentProducer.get()).request(n);
                }
            }
        });
    }

    public static final class RetryWithPredicate
    implements Func1<Observable<? extends Notification<?>>, Observable<? extends Notification<?>>> {
        private Func2<Integer, Throwable, Boolean> predicate;

        public RetryWithPredicate(Func2<Integer, Throwable, Boolean> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Observable<? extends Notification<?>> call(Observable<? extends Notification<?>> ts) {
            return ts.scan(Notification.createOnNext(0), new Func2<Notification<Integer>, Notification<?>, Notification<Integer>>(){

                @Override
                public Notification<Integer> call(Notification<Integer> n, Notification<?> term) {
                    int value = n.getValue();
                    if (((Boolean)RetryWithPredicate.this.predicate.call(value, term.getThrowable())).booleanValue()) {
                        return Notification.createOnNext(value + 1);
                    }
                    return term;
                }
            });
        }
    }

    public static final class RedoFinite
    implements Func1<Observable<? extends Notification<?>>, Observable<?>> {
        private final long count;

        public RedoFinite(long count) {
            this.count = count;
        }

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){
                int num = 0;

                @Override
                public Notification<?> call(Notification<?> terminalNotification) {
                    if (RedoFinite.this.count == 0L) {
                        return terminalNotification;
                    }
                    ++this.num;
                    if ((long)this.num <= RedoFinite.this.count) {
                        return Notification.createOnNext(this.num);
                    }
                    return terminalNotification;
                }
            }).dematerialize();
        }
    }
}

