/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func2;

public final class OperatorScan<R, T>
implements Observable.Operator<R, T> {
    private final R initialValue;
    private final Func2<R, ? super T, R> accumulator;
    private static final Object NO_INITIAL_VALUE = new Object();

    public OperatorScan(R initialValue, Func2<R, ? super T, R> accumulator) {
        this.initialValue = initialValue;
        this.accumulator = accumulator;
    }

    public OperatorScan(Func2<R, ? super T, R> accumulator) {
        this(NO_INITIAL_VALUE, accumulator);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> observer) {
        if (this.initialValue != NO_INITIAL_VALUE) {
            observer.onNext(this.initialValue);
        }
        return new Subscriber<T>(observer){
            private R value;
            {
                super(x0);
                this.value = OperatorScan.this.initialValue;
            }

            @Override
            public void onNext(T value) {
                if (this.value == NO_INITIAL_VALUE) {
                    this.value = value;
                } else {
                    try {
                        this.value = OperatorScan.this.accumulator.call(this.value, value);
                    }
                    catch (Throwable e) {
                        observer.onError(OnErrorThrowable.addValueAsLastCause(e, value));
                    }
                }
                observer.onNext(this.value);
            }

            @Override
            public void onError(Throwable e) {
                observer.onError(e);
            }

            @Override
            public void onCompleted() {
                observer.onCompleted();
            }
        };
    }
}

