/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.schedulers.Schedulers;

public final class OperatorParallelMerge {
    private OperatorParallelMerge() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables) {
        return OperatorParallelMerge.parallelMerge(source, parallelObservables, Schedulers.immediate());
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables, final Scheduler scheduler) {
        return source.groupBy(new StrideMapper(parallelObservables)).map(new Func1<GroupedObservable<Integer, Observable<T>>, Observable<T>>(){

            @Override
            public Observable<T> call(GroupedObservable<Integer, Observable<T>> o) {
                return Observable.merge(o).observeOn(scheduler);
            }
        });
    }

    static final class StrideMapper<T>
    implements Func1<Observable<T>, Integer> {
        final int parallelObservables;
        volatile long rollingCount;
        static final AtomicLongFieldUpdater<StrideMapper> ROLLING_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(StrideMapper.class, "rollingCount");

        public StrideMapper(int parallelObservables) {
            this.parallelObservables = parallelObservables;
        }

        @Override
        public Integer call(Observable<T> t1) {
            return (int)ROLLING_COUNT_UPDATER.incrementAndGet(this) % this.parallelObservables;
        }
    }
}

