/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import rx.Subscriber;
import rx.observables.AbstractOnSubscribe;

public final class OnSubscribeInputStream
extends AbstractOnSubscribe<byte[], InputStream> {
    private final InputStream is;
    private final int size;

    public OnSubscribeInputStream(InputStream is, int size) {
        this.is = is;
        this.size = size;
    }

    protected InputStream onSubscribe(Subscriber<? super byte[]> subscriber) {
        return this.is;
    }

    protected void next(AbstractOnSubscribe.SubscriptionState<byte[], InputStream> state) {
        InputStream is = (InputStream)state.state();
        byte[] buffer = new byte[this.size];
        try {
            int count = is.read(buffer);
            if (count == -1) {
                state.onCompleted();
            } else if (count < this.size) {
                state.onNext((Object)Arrays.copyOf(buffer, count));
            } else {
                state.onNext((Object)buffer);
            }
        }
        catch (IOException e) {
            state.onError((Throwable)e);
        }
    }
}

