/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import ratpack.handling.Context;
import ratpack.render.Renderer;
import ratpack.util.Types;
import ratpack.util.internal.InternalRatpackError;

public abstract class RendererSupport<T>
implements Renderer<T> {
    private final Class<T> type;

    protected RendererSupport() {
        TypeToken typeToken = new TypeToken<T>(this.getClass()){};
        Type type = typeToken.getType();
        if (type instanceof Class) {
            Class rawType;
            this.type = rawType = typeToken.getRawType();
        } else if (type instanceof ParameterizedType) {
            List<Type> typeArgs = Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
            if (Iterables.any(typeArgs, (Predicate)Predicates.not(t -> t.getTypeName().equals("?")))) {
                throw new IllegalArgumentException("Invalid renderable type " + type + ": due to type erasure, type parameter T of RendererSupport must be a Class or a parameterized type with '?' for all type variables (e.g. List<?>)");
            }
            this.type = (Class)Types.cast((Object)typeToken.getRawType());
        } else {
            throw new InternalRatpackError("Unhandled type for renderer support: " + type.getClass());
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public abstract void render(Context var1, T var2) throws Exception;
}

