/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.config.internal.source.DefaultEnvironmentParser;
import ratpack.file.FileSystemBinding;
import ratpack.func.Pair;
import ratpack.func.Predicate;
import ratpack.server.internal.ServerEnvironment;

public class EnvironmentConfigSource
implements ConfigSource {
    public static final String DEFAULT_OBJECT_DELIMITER = "__";
    public static final ratpack.func.Function<String, String> DEFAULT_MAP_FUNC = EnvironmentConfigSource.camelCase();
    private final ServerEnvironment serverEnvironment;
    private final EnvironmentParser parser;

    public EnvironmentConfigSource(ServerEnvironment serverEnvironment) {
        this(serverEnvironment, "RATPACK_");
    }

    public EnvironmentConfigSource(ServerEnvironment serverEnvironment, String prefix) {
        this(serverEnvironment, prefix, DEFAULT_MAP_FUNC);
    }

    public EnvironmentConfigSource(ServerEnvironment serverEnvironment, String prefix, ratpack.func.Function<String, String> mapFunc) {
        this(serverEnvironment, new DefaultEnvironmentParser(EnvironmentConfigSource.filterAndRemoveKeyPrefix((String)Preconditions.checkNotNull((Object)prefix)), EnvironmentConfigSource.splitObjects(DEFAULT_OBJECT_DELIMITER), mapFunc));
    }

    public EnvironmentConfigSource(ServerEnvironment serverEnvironment, EnvironmentParser parser) {
        this.serverEnvironment = serverEnvironment;
        this.parser = parser;
    }

    @Override
    public ObjectNode loadConfigData(ObjectMapper objectMapper, FileSystemBinding fileSystemBinding) throws Exception {
        ObjectNode rootNode = objectMapper.createObjectNode();
        this.serverEnvironment.getenv().entrySet().stream().map(EnvironmentConfigSource.toPair()).flatMap(this.getFilterFunc()).map(this.getPairTokenizerFunc()).forEach(entry -> this.populate(rootNode, this.mapPathSegments((Pair<List<String>, String>)entry), 0, (String)entry.getRight()));
        return rootNode;
    }

    private List<String> mapPathSegments(Pair<List<String>, String> entry) {
        return ((List)entry.getLeft()).stream().map(this.getMapFunc()).collect(Collectors.toList());
    }

    private void populate(ObjectNode node, List<String> path, int pathIndex, String value) {
        String segment = path.get(pathIndex);
        if (pathIndex == path.size() - 1) {
            node.set(segment, (JsonNode)TextNode.valueOf((String)value));
        } else {
            ObjectNode childNode = (ObjectNode)node.get(segment);
            if (childNode == null) {
                childNode = node.putObject(segment);
            }
            this.populate(childNode, path, pathIndex + 1, value);
        }
    }

    private java.util.function.Function<Pair<String, String>, Stream<Pair<String, String>>> getFilterFunc() {
        return ((ratpack.func.Function)this.parser::filter).toFunction();
    }

    private java.util.function.Function<Pair<String, String>, Pair<List<String>, String>> getPairTokenizerFunc() {
        return ((ratpack.func.Function)e -> e.mapLeft(this.parser::tokenize)).toFunction();
    }

    private java.util.function.Function<String, String> getMapFunc() {
        return ((ratpack.func.Function)this.parser::map).toFunction();
    }

    public static ratpack.func.Function<String, String> camelCase() {
        return ratpack.func.Function.fromGuava((Function)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL));
    }

    public static ratpack.func.Function<Pair<String, String>, Stream<Pair<String, String>>> filterAndRemoveKeyPrefix(String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return Stream::of;
        }
        return entry -> Stream.of(entry).filter(EnvironmentConfigSource.keyStartsWith(prefix).toPredicate()).map(EnvironmentConfigSource.removeKeyPrefix(prefix).toFunction());
    }

    public static ratpack.func.Function<String, List<String>> splitObjects(String objectDelimiter) {
        return arg_0 -> ((Splitter)Splitter.on((String)objectDelimiter)).splitToList(arg_0);
    }

    private static Predicate<Pair<String, String>> keyStartsWith(String prefix) {
        return entry -> ((String)entry.getLeft()).startsWith(prefix);
    }

    private static ratpack.func.Function<Pair<String, String>, Pair<String, String>> removeKeyPrefix(String prefix) {
        return entry -> entry.mapLeft(key -> key.substring(prefix.length(), key.length()));
    }

    private static java.util.function.Function<Map.Entry<String, String>, Pair<String, String>> toPair() {
        return e -> Pair.of((Object)((String)e.getKey()), (Object)((String)e.getValue()));
    }
}

