/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import ratpack.config.internal.source.AbstractPropertiesConfigSource;

public class ArgsConfigSource
extends AbstractPropertiesConfigSource {
    private final String separator;
    private final String[] args;

    public ArgsConfigSource(String prefix, String separator, String[] args) {
        super(Optional.ofNullable(prefix));
        this.separator = separator;
        this.args = args;
    }

    @Override
    protected Properties loadProperties() throws Exception {
        Splitter splitter = Splitter.on((String)this.separator).limit(2);
        Properties properties = new Properties();
        for (String arg : this.args) {
            List values = splitter.splitToList((CharSequence)arg);
            if (values.size() == 1) {
                properties.put(values.get(0), "");
                continue;
            }
            properties.put(values.get(0), values.get(1));
        }
        return properties;
    }
}

