/*
 * Decompiled with CFR 0.152.
 */
package ratpack.background.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import ratpack.func.Action;
import ratpack.handling.Background;
import ratpack.handling.Context;
import ratpack.promise.SuccessOrErrorPromise;
import ratpack.promise.SuccessPromise;
import ratpack.util.ExceptionUtils;

public class DefaultBackground
implements Background {
    private final ExecutorService foregroundExecutor;
    private final ListeningExecutorService backgroundExecutor;
    private final ThreadLocal<Context> contextThreadLocal;

    public DefaultBackground(ExecutorService foregroundExecutor, ListeningExecutorService backgroundExecutor, ThreadLocal<Context> contextThreadLocal) {
        this.foregroundExecutor = foregroundExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.contextThreadLocal = contextThreadLocal;
    }

    @Override
    public <T> SuccessOrErrorPromise<T> exec(Callable<T> operation) {
        return new DefaultSuccessOrErrorPromise<T>(operation, this.contextThreadLocal.get());
    }

    private class DefaultSuccessPromise<T>
    implements SuccessPromise<T> {
        private final Context context;
        private final Callable<T> backgroundAction;
        private final Action<Throwable> errorHandler;

        DefaultSuccessPromise(Context context, Callable<T> backgroundAction, Action<Throwable> errorHandler) {
            this.context = context;
            this.backgroundAction = backgroundAction;
            this.errorHandler = errorHandler;
        }

        @Override
        public void then(final Action<? super T> then) {
            ListenableFuture future = DefaultBackground.this.backgroundExecutor.submit(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    DefaultBackground.this.contextThreadLocal.set(DefaultSuccessPromise.this.context);
                    try {
                        Object v = DefaultSuccessPromise.this.backgroundAction.call();
                        return v;
                    }
                    finally {
                        DefaultBackground.this.contextThreadLocal.remove();
                    }
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(T result) {
                    DefaultBackground.this.contextThreadLocal.set(DefaultSuccessPromise.this.context);
                    try {
                        then.execute(result);
                    }
                    catch (Exception e) {
                        DefaultSuccessPromise.this.context.error(e);
                    }
                    finally {
                        DefaultBackground.this.contextThreadLocal.remove();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    DefaultBackground.this.contextThreadLocal.set(DefaultSuccessPromise.this.context);
                    try {
                        DefaultSuccessPromise.this.errorHandler.execute(t);
                    }
                    catch (Exception e) {
                        DefaultSuccessPromise.this.context.error(e);
                    }
                    finally {
                        DefaultBackground.this.contextThreadLocal.remove();
                    }
                }
            }, (Executor)DefaultBackground.this.foregroundExecutor);
        }
    }

    private class DefaultSuccessOrErrorPromise<T>
    implements SuccessOrErrorPromise<T> {
        private final Callable<T> backgroundAction;
        protected final Context context;

        DefaultSuccessOrErrorPromise(Callable<T> backgroundAction, Context context) {
            this.backgroundAction = backgroundAction;
            this.context = context;
        }

        @Override
        public SuccessPromise<T> onError(final Action<? super Throwable> errorHandler) {
            return new DefaultSuccessPromise<T>(this.context, this.backgroundAction, new Action<Throwable>(){

                @Override
                public void execute(Throwable t) {
                    try {
                        errorHandler.execute(t);
                    }
                    catch (Throwable errorHandlerError) {
                        new ForwardToContextErrorHandler().execute(errorHandlerError);
                    }
                }
            });
        }

        @Override
        public void then(Action<? super T> then) {
            new DefaultSuccessPromise<T>(this.context, this.backgroundAction, new ForwardToContextErrorHandler()).then(then);
        }

        class ForwardToContextErrorHandler
        implements Action<Throwable> {
            ForwardToContextErrorHandler() {
            }

            @Override
            public void execute(Throwable t) {
                DefaultSuccessOrErrorPromise.this.context.error(ExceptionUtils.toException(t));
            }
        }
    }
}

