/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.test.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class MockResult
implements Result {
    private final Flux<Result.Segment> segments;

    private MockResult(Flux<Result.Segment> segments) {
        this.segments = Assert.requireNonNull(segments, "segments must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockResult empty() {
        return MockResult.builder().build();
    }

    public Flux<Integer> getRowsUpdated() {
        return this.segments.filter(Result.UpdateCount.class::isInstance).cast(Result.UpdateCount.class).map(Result.UpdateCount::value).collect(Collectors.summingInt(Long::intValue)).flux();
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        return this.segments.filter(Result.RowSegment.class::isInstance).cast(Result.RowSegment.class).map(it -> mappingFunction.apply(it.row(), it.row().getMetadata()));
    }

    public <T> Publisher<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "f must not be null");
        return this.segments.filter(it -> it instanceof Result.RowSegment || it instanceof Result.OutSegment).map(it -> {
            if (it instanceof Result.OutSegment) {
                return mappingFunction.apply((Readable)((Result.OutSegment)it).outParameters());
            }
            return mappingFunction.apply((Readable)((Result.RowSegment)it).row());
        });
    }

    public String toString() {
        return "MockResult{segments=" + this.segments + '}';
    }

    public Result filter(Predicate<Result.Segment> filter) {
        Assert.requireNonNull(filter, "mappingFunction must not be null");
        return new MockResult((Flux<Result.Segment>)this.segments.filter(filter));
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        return this.segments.flatMap(mappingFunction);
    }

    public static Result.UpdateCount updateCount(long value) {
        return () -> value;
    }

    public static Result.RowSegment row(Row row) {
        Assert.requireNonNull(row, "row must not be null");
        return () -> row;
    }

    public static Result.OutSegment outParameters(OutParameters parameters) {
        Assert.requireNonNull(parameters, "parameters must not be null");
        return () -> parameters;
    }

    public static final class Builder {
        private final List<Supplier<Result.Segment>> segments = new ArrayList<Supplier<Result.Segment>>();

        private Builder() {
        }

        public MockResult build() {
            return new MockResult(Flux.fromIterable(this.segments).map(Supplier::get));
        }

        public Builder segment(Result.Segment ... segments) {
            Assert.requireNonNull(segments, "segments must not be null");
            Stream.of(segments).peek(segment -> Assert.requireNonNull(segment, "segment must not be null")).map(segment -> () -> segment).forEach(this.segments::add);
            return this;
        }

        public Builder row(Row ... rows) {
            Assert.requireNonNull(rows, "rows must not be null");
            Stream.of(rows).peek(row -> Assert.requireNonNull(row, "row must not be null")).map(row -> () -> MockResult.row(row)).forEach(this.segments::add);
            return this;
        }

        @Deprecated
        public Builder rowMetadata(RowMetadata rowMetadata) {
            return this;
        }

        public Builder rowsUpdated(long rowsUpdated) {
            this.segments.add(() -> MockResult.updateCount(rowsUpdated));
            return this;
        }

        public Builder outParameters(OutParameters outParameters) {
            Assert.requireNonNull(outParameters, "outParameters must not be null");
            this.segments.add(() -> MockResult.outParameters(outParameters));
            return this;
        }

        public String toString() {
            return "Builder{, segments=" + this.segments + '}';
        }
    }
}

