/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.OutParametersMetadata;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.MockOutParametersMetadata;
import io.r2dbc.spi.test.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class MockOutParameters
implements OutParameters {
    private final Map<Identified, Object> identified;
    private final OutParametersMetadata metadata;

    private MockOutParameters(Map<Identified, Object> identified, OutParametersMetadata metadata) {
        this.identified = Assert.requireNonNull(identified, "identified must not be null");
        this.metadata = Assert.requireNonNull(metadata, "metadata must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockOutParameters empty() {
        return MockOutParameters.builder().build();
    }

    public <T> T get(int index, Class<T> type) {
        Assert.requireNonNull(type, "type must not be null");
        Identified identified = new Identified(index, type);
        if (!this.identified.containsKey(identified)) {
            throw new AssertionError((Object)String.format("Unexpected call to get(Object, Class) with values '%s', '%s'", index, type.getName()));
        }
        return (T)this.identified.get(identified);
    }

    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Identified identified = new Identified(name, type);
        if (!this.identified.containsKey(identified)) {
            throw new AssertionError((Object)String.format("Unexpected call to get(Object, Class) with values '%s', '%s'", name, type.getName()));
        }
        return (T)this.identified.get(identified);
    }

    public OutParametersMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "MockOutParameters{identified=" + this.identified + '}';
    }

    private static final class Identified {
        private final Object identifier;
        private final Class<?> type;

        private Identified(Object identifier, Class<?> type) {
            this.identifier = Assert.requireNonNull(identifier, "identifier must not be null");
            this.type = Assert.requireNonNull(type, "type must not be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identified that = (Identified)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.type);
        }

        public String toString() {
            return "Identified{identifier=" + this.identifier + ", type=" + this.type + '}';
        }
    }

    public static final class Builder {
        private final Map<Identified, Object> identified = new HashMap<Identified, Object>();
        private OutParametersMetadata metadata = MockOutParametersMetadata.empty();

        private Builder() {
        }

        public MockOutParameters build() {
            return new MockOutParameters(this.identified, this.metadata);
        }

        public Builder identified(Object identifier, Class<?> type, @Nullable Object value) {
            Assert.requireNonNull(identifier, "identifier must not be null");
            Assert.requireNonNull(type, "type must not be null");
            this.identified.put(new Identified(identifier, type), value);
            return this;
        }

        public Builder metadata(OutParametersMetadata outParametersMetadata) {
            this.metadata = Assert.requireNonNull(outParametersMetadata, "outParametersMetadata must not be null");
            return this;
        }

        public String toString() {
            return "Builder{identified=" + this.identified + "outParametersMetadata=" + this.metadata + '}';
        }
    }
}

