/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.MockBatch;
import io.r2dbc.spi.test.MockConnectionMetadata;
import io.r2dbc.spi.test.MockStatement;
import io.r2dbc.spi.test.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class MockConnection
implements Connection {
    private final MockBatch batch;
    private final MockStatement statement;
    private boolean autoCommit = true;
    private boolean beginTransactionCalled = false;
    private boolean closeCalled = false;
    private boolean commitTransactionCalled = false;
    private String createSavepointName;
    private String createStatementSql;
    private String releaseSavepointName;
    private boolean rollbackTransactionCalled = false;
    private String rollbackTransactionToSavepointName;
    private TransactionDefinition beginTransactionDefinition;
    private IsolationLevel setTransactionIsolationLevelIsolationLevel;
    private boolean valid;
    private boolean validateCalled;
    private ValidationDepth validationDepth;

    private MockConnection(@Nullable MockBatch batch, @Nullable MockStatement statement, boolean valid) {
        this.batch = batch;
        this.statement = statement;
        this.valid = valid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockConnection empty() {
        return MockConnection.builder().build();
    }

    public Mono<Void> beginTransaction() {
        this.beginTransactionCalled = true;
        return Mono.empty();
    }

    public Publisher<Void> beginTransaction(TransactionDefinition definition) {
        this.beginTransactionCalled = true;
        this.beginTransactionDefinition = definition;
        return Mono.empty();
    }

    public Mono<Void> close() {
        this.closeCalled = true;
        return Mono.empty();
    }

    public Mono<Void> commitTransaction() {
        this.commitTransactionCalled = true;
        return Mono.empty();
    }

    public MockBatch createBatch() {
        if (this.batch == null) {
            throw new AssertionError((Object)"Unexpected call to createBatch()");
        }
        return this.batch;
    }

    public Mono<Void> createSavepoint(String name) {
        this.createSavepointName = Assert.requireNonNull(name, "name must not be null");
        return Mono.empty();
    }

    public MockStatement createStatement(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if (this.statement == null) {
            throw new AssertionError((Object)"Unexpected call to createStatement(String)");
        }
        this.createStatementSql = sql;
        return this.statement;
    }

    @Nullable
    public String getCreateSavepointName() {
        return this.createSavepointName;
    }

    @Nullable
    public String getCreateStatementSql() {
        return this.createStatementSql;
    }

    @Nullable
    public String getReleaseSavepointName() {
        return this.releaseSavepointName;
    }

    @Nullable
    public String getRollbackTransactionToSavepointName() {
        return this.rollbackTransactionToSavepointName;
    }

    public ConnectionMetadata getMetadata() {
        return MockConnectionMetadata.INSTANCE;
    }

    public TransactionDefinition getBeginTransactionDefinition() {
        return this.beginTransactionDefinition;
    }

    @Nullable
    public IsolationLevel getTransactionIsolationLevel() {
        return this.setTransactionIsolationLevelIsolationLevel;
    }

    @Nullable
    public ValidationDepth getValidationDepth() {
        return this.validationDepth;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isBeginTransactionCalled() {
        return this.beginTransactionCalled;
    }

    public boolean isCloseCalled() {
        return this.closeCalled;
    }

    public boolean isCommitTransactionCalled() {
        return this.commitTransactionCalled;
    }

    public boolean isRollbackTransactionCalled() {
        return this.rollbackTransactionCalled;
    }

    public boolean isValidateCalled() {
        return this.validateCalled;
    }

    public Mono<Void> releaseSavepoint(String name) {
        this.releaseSavepointName = Assert.requireNonNull(name, "name must not be null");
        return Mono.empty();
    }

    public Mono<Void> rollbackTransaction() {
        this.rollbackTransactionCalled = true;
        return Mono.empty();
    }

    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        this.rollbackTransactionToSavepointName = Assert.requireNonNull(name, "name must not be null");
        return Mono.empty();
    }

    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return Mono.empty();
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        this.setTransactionIsolationLevelIsolationLevel = Assert.requireNonNull(isolationLevel, "isolation level must not be null");
        return Mono.empty();
    }

    public Publisher<Boolean> validate(ValidationDepth depth) {
        this.validationDepth = Assert.requireNonNull(depth, "depth must not be null");
        this.validateCalled = true;
        return Mono.just((Object)this.valid);
    }

    public String toString() {
        return "MockConnection{batch=" + this.batch + ", statement=" + this.statement + ", beginTransactionCalled=" + this.beginTransactionCalled + ", closeCalled=" + this.closeCalled + ", commitTransactionCalled=" + this.commitTransactionCalled + ", createSavepointName='" + this.createSavepointName + '\'' + ", createStatementSql='" + this.createStatementSql + '\'' + ", releaseSavepointName='" + this.releaseSavepointName + '\'' + ", rollbackTransactionCalled=" + this.rollbackTransactionCalled + ", rollbackTransactionToSavepointName='" + this.rollbackTransactionToSavepointName + '\'' + ", setTransactionIsolationLevelIsolationLevel=" + this.setTransactionIsolationLevelIsolationLevel + ", valid=" + this.valid + ", validateCalled=" + this.validateCalled + ", validationDepth=" + this.validationDepth + '}';
    }

    public static final class Builder {
        private MockBatch batch;
        private MockStatement statement;
        private boolean valid;

        private Builder() {
        }

        public Builder batch(MockBatch batch) {
            this.batch = Assert.requireNonNull(batch, "batch must not be null");
            return this;
        }

        public MockConnection build() {
            return new MockConnection(this.batch, this.statement, this.valid);
        }

        public Builder statement(MockStatement statement) {
            this.statement = Assert.requireNonNull(statement, "statement must not be null");
            return this;
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public String toString() {
            return "Builder{batch=" + this.batch + ", statement=" + this.statement + ", valid=" + this.valid + '}';
        }
    }
}

