/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.test.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MockResult
implements Result {
    private final Mono<RowMetadata> rowMetadata;
    private final Flux<Row> rows;
    private final Flux<Integer> rowsUpdated;

    private MockResult(Mono<RowMetadata> rowMetadata, Flux<Row> rows, Flux<Integer> rowsUpdated) {
        this.rowMetadata = Assert.requireNonNull(rowMetadata, "rowMetadata must not be null");
        this.rows = Assert.requireNonNull(rows, "rows must not be null");
        this.rowsUpdated = Assert.requireNonNull(rowsUpdated, "rowsUpdated must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockResult empty() {
        return MockResult.builder().build();
    }

    public Flux<Integer> getRowsUpdated() {
        return this.rowsUpdated;
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "f must not be null");
        return this.rows.zipWith((Publisher)this.rowMetadata.repeat()).map(tuple -> {
            Row row = (Row)tuple.getT1();
            RowMetadata rowMetadata = (RowMetadata)tuple.getT2();
            return mappingFunction.apply(row, rowMetadata);
        });
    }

    public String toString() {
        return "MockResult{rowMetadata=" + this.rowMetadata + ", rows=" + this.rows + ", rowsUpdated=" + this.rowsUpdated + '}';
    }

    public static final class Builder {
        private final List<Row> rows = new ArrayList<Row>();
        private final List<Integer> rowsUpdated = new ArrayList<Integer>();
        private RowMetadata rowMetadata;

        private Builder() {
        }

        public MockResult build() {
            return new MockResult(Mono.justOrEmpty((Object)this.rowMetadata), Flux.fromIterable(this.rows), Flux.fromIterable(this.rowsUpdated));
        }

        public Builder row(Row ... rows) {
            Assert.requireNonNull(rows, "rows must not be null");
            Stream.of(rows).peek(row -> Assert.requireNonNull(row, "row must not be null")).forEach(this.rows::add);
            return this;
        }

        public Builder rowMetadata(RowMetadata rowMetadata) {
            this.rowMetadata = Assert.requireNonNull(rowMetadata, "rowMetadata must not be null");
            return this;
        }

        public Builder rowsUpdated(Integer rowsUpdated) {
            Assert.requireNonNull(rowsUpdated, "rowsUpdated must not be null");
            this.rowsUpdated.add(rowsUpdated);
            return this;
        }

        public String toString() {
            return "Builder{rowMetadata=" + this.rowMetadata + ", rows=" + this.rows + ", rowsUpdated=" + this.rowsUpdated + '}';
        }
    }
}

