/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.Nullable;

public final class MockColumnMetadata
implements ColumnMetadata {
    private final Class<?> javaType;
    private final String name;
    private final Object nativeTypeMetadata;
    private final Nullability nullability;
    private final Integer precision;
    private final Integer scale;

    private MockColumnMetadata(@Nullable Class<?> javaType, String name, @Nullable Object nativeTypeMetadata, Nullability nullability, @Nullable Integer precision, @Nullable Integer scale) {
        this.javaType = javaType;
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.nativeTypeMetadata = nativeTypeMetadata;
        this.nullability = Assert.requireNonNull(nullability, "nullability must not be null");
        this.precision = precision;
        this.scale = scale;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockColumnMetadata empty() {
        return MockColumnMetadata.builder().name("test-name").nullability(Nullability.UNKNOWN).build();
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeTypeMetadata() {
        return this.nativeTypeMetadata;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String toString() {
        return "MockColumnMetadata{javaType=" + this.javaType + ", name='" + this.name + '\'' + ", nativeTypeMetadata=" + this.nativeTypeMetadata + ", nullability=" + this.nullability + ", precision=" + this.precision + ", scale=" + this.scale + '}';
    }

    public static final class Builder {
        private Class<?> javaType;
        private String name;
        private Object nativeTypeMetadata;
        private Nullability nullability = Nullability.UNKNOWN;
        private Integer precision;
        private Integer scale;

        private Builder() {
        }

        public MockColumnMetadata build() {
            return new MockColumnMetadata(this.javaType, this.name, this.nativeTypeMetadata, this.nullability, this.precision, this.scale);
        }

        public Builder javaType(Class<?> type) {
            this.javaType = Assert.requireNonNull(type, "javaType must not be null");
            return this;
        }

        public Builder name(String name) {
            this.name = Assert.requireNonNull(name, "name must not be null");
            return this;
        }

        public Builder nativeTypeMetadata(Object nativeTypeMetadata) {
            this.nativeTypeMetadata = Assert.requireNonNull(nativeTypeMetadata, "nativeTypeMetadata must not be null");
            return this;
        }

        public Builder nullability(Nullability nullability) {
            this.nullability = Assert.requireNonNull(nullability, "nullability must not be null");
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = Assert.requireNonNull(precision, "precision must not be null");
            return this;
        }

        public Builder scale(Integer precision) {
            this.scale = Assert.requireNonNull(precision, "scale must not be null");
            return this;
        }
    }
}

