/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Clob;
import io.r2dbc.spi.test.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MockClob
implements Clob {
    private final Flux<CharSequence> stream;
    private boolean discardCalled = false;

    private MockClob(Flux<CharSequence> stream) {
        this.stream = Assert.requireNonNull(stream, "stream must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockClob empty() {
        return MockClob.builder().build();
    }

    public Publisher<Void> discard() {
        this.discardCalled = true;
        return Mono.empty();
    }

    public boolean isDiscardCalled() {
        return this.discardCalled;
    }

    public Publisher<CharSequence> stream() {
        return this.stream;
    }

    public String toString() {
        return "MockClob{stream=" + this.stream + ", discardCalled=" + this.discardCalled + '}';
    }

    public static final class Builder {
        private final List<CharSequence> items = new ArrayList<CharSequence>();

        private Builder() {
        }

        public MockClob build() {
            return new MockClob(Flux.fromIterable(this.items));
        }

        public Builder item(CharSequence ... items) {
            Assert.requireNonNull(items, "items must not be null");
            Stream.of(items).peek(item -> Assert.requireNonNull(item, "item must not be null")).forEach(this.items::add);
            return this;
        }

        public String toString() {
            return "Builder{items=" + this.items + '}';
        }
    }
}

