/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import io.r2dbc.spi.test.Assert;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public interface TestKit<T> {
    public static <T> Mono<T> close(Connection connection) {
        return Mono.from((Publisher)connection.close()).then(Mono.empty());
    }

    public static <T> Mono<T> discard(Blob blob) {
        return Mono.from((Publisher)blob.discard()).then(Mono.empty());
    }

    public static <T> Mono<T> discard(Clob clob) {
        return Mono.from((Publisher)clob.discard()).then(Mono.empty());
    }

    public static Mono<List<Integer>> extractColumns(Result result) {
        return Flux.from((Publisher)result.map((row, rowMetadata) -> (Integer)row.get("value", Integer.class))).collectList();
    }

    public static Mono<Integer> extractRowsUpdated(Result result) {
        return Mono.from((Publisher)result.getRowsUpdated());
    }

    public ConnectionFactory getConnectionFactory();

    public String getCreateTableWithAutogeneratedKey();

    public String getPlaceholder(int var1);

    public T getIdentifier(int var1);

    public JdbcOperations getJdbcOperations();

    @Test
    default public void autoCommitByDefault() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.just((Object)connection.isAutoCommit()).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)true).as("new connections are in auto-commit mode").verifyComplete();
    }

    @Test
    default public void changeAutoCommitCommitsTransaction() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.setAutoCommit(false)).thenMany(connection.beginTransaction()).thenMany(connection.createStatement("INSERT INTO test VALUES(200)").execute()).flatMap(Result::getRowsUpdated).thenMany(connection.setAutoCommit(true)).thenMany(connection.createStatement("SELECT value FROM test").execute()).flatMap(it -> it.map((row, metadata) -> row.get("value"))).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)200).as("autoCommit(true) committed the transaction. Expecting a value to be present").verifyComplete();
    }

    @Test
    default public void sameAutoCommitLeavesTransactionUnchanged() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.setAutoCommit(false)).thenMany(connection.beginTransaction()).thenMany(connection.createStatement("INSERT INTO test VALUES(200)").execute()).flatMap(Result::getRowsUpdated).thenMany(connection.setAutoCommit(false)).thenMany(connection.rollbackTransaction()).thenMany(connection.createStatement("SELECT value FROM test").execute()).flatMap(it -> it.map((row, metadata) -> row.get("value"))).concatWith(TestKit.close(connection))).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void batch() {
        this.getJdbcOperations().execute("INSERT INTO test VALUES (100)");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createBatch().add("INSERT INTO test VALUES(200)").add("SELECT value FROM test").execute()).concatWith(TestKit.close(connection))).flatMap(Result::getRowsUpdated).then().as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void bindFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMap(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s)", this.getPlaceholder(0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.bind(0, null), (String)"bind(0, null) should fail");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> statement.bind(99, (Object)""), (String)"bind(nonexistent-index, null) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), null), (String)"bind(identifier, null) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), Class.class), (String)"bind(identifier, Class.class) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.bind("unknown", (Object)""), (String)"bind(unknown-placeholder, \"\") should fail");
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void bindNull() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s)", this.getPlaceholder(0)));
            TestKit.bindNull(statement, this.getIdentifier(0), Integer.class);
            return Flux.from((Publisher)statement.add().execute()).concatWith(TestKit.close(connection));
        }).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void bindNullFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMap(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s)", this.getPlaceholder(0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.bindNull(null, String.class), (String)"bindNull(null, \u2026) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), null), (String)"bindNull(identifier, null) should fail");
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void blobInsert() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO blob_test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), Blob.from((Publisher)Mono.just((Object)StandardCharsets.UTF_8.encode("test-value"))));
            return Flux.from((Publisher)statement.execute()).concatWith(TestKit.close(connection));
        }).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void blobSelect() {
        this.getJdbcOperations().execute("INSERT INTO blob_test VALUES (?)", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback((LobHandler)new DefaultLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                lobCreator.setBlobAsBytes(ps, 1, StandardCharsets.UTF_8.encode("test-value").array());
            }
        });
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT * from blob_test").execute()).flatMap(result -> result.map((row, rowMetadata) -> row.get("value"))).cast(ByteBuffer.class).map(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNextMatches(actual -> {
            ByteBuffer expected = StandardCharsets.UTF_8.encode("test-value");
            return Arrays.equals(expected.array(), actual);
        }).verifyComplete();
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT * from blob_test").execute()).flatMap(result -> result.map((row, rowMetadata) -> (Blob)row.get("value", Blob.class))).flatMap(blob -> Flux.from((Publisher)blob.stream()).reduce(ByteBuffer::put).concatWith(TestKit.discard(blob))).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNextMatches(actual -> {
            ByteBuffer expected = StandardCharsets.UTF_8.encode("test-value");
            return Arrays.equals(expected.array(), actual.array());
        }).verifyComplete();
    }

    default public String blobType() {
        return "BLOB";
    }

    @Test
    default public void clobInsert() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO clob_test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), Clob.from((Publisher)Mono.just((Object)"test-value")));
            return Flux.from((Publisher)statement.execute()).concatWith(TestKit.close(connection));
        }).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void clobSelect() {
        this.getJdbcOperations().execute("INSERT INTO clob_test VALUES (?)", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback((LobHandler)new DefaultLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                lobCreator.setClobAsString(ps, 1, "test-value");
            }
        });
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT * from clob_test").execute()).flatMap(result -> result.map((row, rowMetadata) -> row.get("value"))).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)"test-value").as("value from select").verifyComplete();
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT * from clob_test").execute()).flatMap(result -> result.map((row, rowMetadata) -> (Clob)row.get("value", Clob.class))).flatMap(clob -> Flux.from((Publisher)clob.stream()).reduce((Object)new StringBuilder(), StringBuilder::append).map(StringBuilder::toString).concatWith(TestKit.discard(clob))).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)"test-value").as("value from select").verifyComplete();
    }

    default public String clobType() {
        return "CLOB";
    }

    @Test
    default public void columnMetadata() {
        this.getJdbcOperations().execute("INSERT INTO test_two_column VALUES (100, 'hello')");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT col1 AS value, col2 AS value FROM test_two_column").execute()).flatMap(result -> result.map((row, rowMetadata) -> {
            Collection columnNames = rowMetadata.getColumnNames();
            return Arrays.asList(rowMetadata.getColumnMetadata("value").getName(), rowMetadata.getColumnMetadata("VALUE").getName(), columnNames.contains("value"), columnNames.contains("VALUE"));
        })).flatMapIterable(Function.identity()).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)"value").as("Column label col1").expectNext((Object)"value").as("Column label col1 (get by uppercase)").expectNext((Object)true).as("getColumnNames.contains(value)").expectNext((Object)true).as("getColumnNames.contains(VALUE)").verifyComplete();
    }

    @Test
    default public void compoundStatement() {
        this.getJdbcOperations().execute("INSERT INTO test VALUES (100)");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT value FROM test; SELECT value FROM test").execute()).flatMap(TestKit::extractColumns).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext(Collections.singletonList(100)).as("value from first select").expectNext(Collections.singletonList(100)).as("value from second select").verifyComplete();
    }

    @Test
    default public void createStatementFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMap(connection -> {
            Assertions.assertThrows(IllegalArgumentException.class, () -> connection.createStatement(null));
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    @BeforeEach
    default public void createTable() {
        this.getJdbcOperations().execute("CREATE TABLE test ( value INTEGER )");
        this.getJdbcOperations().execute("CREATE TABLE test_two_column ( col1 INTEGER, col2 VARCHAR(100) )");
        this.getJdbcOperations().execute(String.format("CREATE TABLE blob_test ( value %s )", this.blobType()));
        this.getJdbcOperations().execute(String.format("CREATE TABLE clob_test ( value %s )", this.clobType()));
    }

    @AfterEach
    default public void dropTable() {
        this.getJdbcOperations().execute("DROP TABLE test");
        this.getJdbcOperations().execute("DROP TABLE test_two_column");
        this.getJdbcOperations().execute("DROP TABLE blob_test");
        this.getJdbcOperations().execute("DROP TABLE clob_test");
    }

    @Test
    default public void duplicateColumnNames() {
        this.getJdbcOperations().execute("INSERT INTO test_two_column VALUES (100, 'hello')");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.from((Publisher)connection.createStatement("SELECT col1 AS value, col2 AS value FROM test_two_column").execute()).flatMap(result -> result.map((row, rowMetadata) -> Arrays.asList(row.get("value"), row.get("VALUE")))).flatMapIterable(Function.identity()).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)100).as("value from col1").expectNext((Object)100).as("value from col1 (upper case)").verifyComplete();
    }

    @Test
    default public void prepareStatement() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s)", this.getPlaceholder(0)));
            IntStream.range(0, 10).forEach(i -> TestKit.bind(statement, this.getIdentifier(0), i).add());
            return Flux.from((Publisher)statement.execute()).concatWith(TestKit.close(connection));
        }).as(StepVerifier::create)).expectNextCount(10L).as("values from insertions").verifyComplete();
    }

    @Test
    default public void prepareStatementWithIncompleteBatchFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s,%s)", this.getPlaceholder(0), this.getPlaceholder(1)));
            TestKit.bind(statement, this.getIdentifier(0), 0);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Statement)statement).add());
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void prepareStatementWithIncompleteBindingFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES(%s,%s)", this.getPlaceholder(0), this.getPlaceholder(1)));
            TestKit.bind(statement, this.getIdentifier(0), 0);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Statement)statement).execute());
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    default public String getInsertIntoWithAutogeneratedKey() {
        return "INSERT INTO test VALUES(100)";
    }

    @Test
    default public void returnGeneratedValues() {
        this.getJdbcOperations().execute("DROP TABLE test");
        this.getJdbcOperations().execute(this.getCreateTableWithAutogeneratedKey());
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement(this.getInsertIntoWithAutogeneratedKey());
            statement.returnGeneratedValues(new String[0]);
            return Flux.from((Publisher)statement.execute()).concatWith(TestKit.close(connection)).flatMap(it -> it.map((row, rowMetadata) -> row.get(0)));
        }).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
    }

    @Test
    default public void returnGeneratedValuesFails() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> {
            Statement statement = connection.createStatement("INSERT INTO test");
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.returnGeneratedValues((String[])null));
            return TestKit.close(connection);
        }).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void savePoint() {
        this.getJdbcOperations().execute("INSERT INTO test VALUES (100)");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(TestKit::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(connection.createSavepoint("test_savepoint")).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 300);
            return statement.execute();
        }).flatMap(TestKit::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(connection.rollbackTransactionToSavepoint("test_savepoint")).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext(Collections.singletonList(100)).as("value from select").expectNext((Object)1).as("rows inserted").expectNext(Arrays.asList(100, 200)).as("values from select").expectNext((Object)1).as("rows inserted").expectNext(Arrays.asList(100, 200, 300)).as("values from select").expectNext(Arrays.asList(100, 200)).as("values from select").verifyComplete();
    }

    @Test
    default public void savePointStartsTransaction() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Mono.from((Publisher)connection.createSavepoint("test_savepoint")).then(Mono.fromSupplier(() -> ((Connection)connection).isAutoCommit())).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext((Object)false).as("createSavepoint starts a transaction").verifyComplete();
    }

    @Test
    default public void transactionCommit() {
        this.getJdbcOperations().execute("INSERT INTO test VALUES (100)");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(TestKit::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(connection.commitTransaction()).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext(Collections.singletonList(100)).as("value from select").expectNext((Object)1).as("rows inserted").expectNext(Arrays.asList(100, 200)).as("values from select").expectNext(Arrays.asList(100, 200)).as("values from select").verifyComplete();
    }

    @Test
    default public void transactionRollback() {
        this.getJdbcOperations().execute("INSERT INTO test VALUES (100)");
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(String.format("INSERT INTO test VALUES (%s)", this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(TestKit::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(connection.rollbackTransaction()).concatWith((Publisher)Flux.from((Publisher)connection.createStatement("SELECT value FROM test").execute()).flatMap(TestKit::extractColumns)).concatWith(TestKit.close(connection))).as(StepVerifier::create)).expectNext(Collections.singletonList(100)).as("value from select").expectNext((Object)1).as("rows inserted").expectNext(Arrays.asList(100, 200)).as("values from select").expectNext(Collections.singletonList(100)).as("value from select").verifyComplete();
    }

    @Test
    default public void validate() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.concat((Publisher[])new Publisher[]{connection.validate(ValidationDepth.LOCAL), connection.validate(ValidationDepth.REMOTE), connection.close(), connection.validate(ValidationDepth.LOCAL), connection.validate(ValidationDepth.REMOTE)})).as(StepVerifier::create)).expectNext((Object)true).as("successful local validation").expectNext((Object)true).as("successful remote validation").expectNext((Object)false).as("failed local validation after close").expectNext((Object)false).as("failed remote validation after close").verifyComplete();
    }

    public static Statement bind(Statement statement, Object identifier, Object value) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof String) {
            return statement.bind((String)identifier, value);
        }
        if (identifier instanceof Integer) {
            return statement.bind(((Integer)identifier).intValue(), value);
        }
        throw new IllegalArgumentException(String.format("Identifier %s must be a String or Integer. Was: %s", identifier, identifier.getClass().getName()));
    }

    public static Statement bindNull(Statement statement, Object identifier, Class<?> type) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof String) {
            return statement.bindNull((String)identifier, type);
        }
        if (identifier instanceof Integer) {
            return statement.bindNull(((Integer)identifier).intValue(), type);
        }
        throw new IllegalArgumentException(String.format("Identifier %s must be a String or Integer. Was: %s", identifier, identifier.getClass().getName()));
    }
}

