/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class MockRow
implements Row {
    private final Map<Identified, Object> identified;

    private MockRow(Map<Identified, Object> identified) {
        this.identified = Assert.requireNonNull(identified, "identified must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockRow empty() {
        return MockRow.builder().build();
    }

    public <T> T get(int index, Class<T> type) {
        Assert.requireNonNull(type, "type must not be null");
        Identified identified = new Identified(index, type);
        if (!this.identified.containsKey(identified)) {
            throw new AssertionError((Object)String.format("Unexpected call to get(Object, Class) with values '%s', '%s'", index, type.getName()));
        }
        return (T)this.identified.get(identified);
    }

    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Identified identified = new Identified(name, type);
        if (!this.identified.containsKey(identified)) {
            throw new AssertionError((Object)String.format("Unexpected call to get(Object, Class) with values '%s', '%s'", name, type.getName()));
        }
        return (T)this.identified.get(identified);
    }

    public String toString() {
        return "MockRow{identified=" + this.identified + '}';
    }

    private static final class Identified {
        private final Object identifier;
        private final Class<?> type;

        private Identified(Object identifier, Class<?> type) {
            this.identifier = Assert.requireNonNull(identifier, "identifier must not be null");
            this.type = Assert.requireNonNull(type, "type must not be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identified that = (Identified)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.type);
        }

        public String toString() {
            return "Identified{identifier=" + this.identifier + ", type=" + this.type + '}';
        }
    }

    public static final class Builder {
        private final Map<Identified, Object> identified = new HashMap<Identified, Object>();

        private Builder() {
        }

        public MockRow build() {
            return new MockRow(this.identified);
        }

        public Builder identified(Object identifier, Class<?> type, @Nullable Object value) {
            Assert.requireNonNull(identifier, "identifier must not be null");
            Assert.requireNonNull(type, "type must not be null");
            this.identified.put(new Identified(identifier, type), value);
            return this;
        }

        public String toString() {
            return "Builder{identified=" + this.identified + '}';
        }
    }
}

