/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.test.Assert;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

public final class MockBatch
implements Batch {
    private final Flux<Result> results;
    private final List<String> sqls = new ArrayList<String>();

    private MockBatch(Flux<Result> results) {
        this.results = Assert.requireNonNull(results, "results must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockBatch empty() {
        return MockBatch.builder().build();
    }

    public MockBatch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        this.sqls.add(sql);
        return this;
    }

    public Flux<Result> execute() {
        return this.results;
    }

    public List<String> getSqls() {
        return this.sqls;
    }

    public String toString() {
        return "MockBatch{results=" + this.results + ", sqls=" + this.sqls + '}';
    }

    public static final class Builder {
        private final List<Result> results = new ArrayList<Result>();

        private Builder() {
        }

        public MockBatch build() {
            return new MockBatch(Flux.fromIterable(this.results));
        }

        public Builder result(Result result) {
            Assert.requireNonNull(result, "result must not be null");
            this.results.add(result);
            return this;
        }

        public String toString() {
            return "Builder{results=" + this.results + '}';
        }
    }
}

