/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.core.R2dbcProxyException;
import io.r2dbc.proxy.listener.ResultRowConverter;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Row;
import java.lang.reflect.Method;

public final class RowCallbackHandler
extends CallbackHandlerSupport {
    private final Row row;
    private final QueryExecutionInfo queryExecutionInfo;

    public RowCallbackHandler(Row row, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.row = Assert.requireNonNull(row, "row must not be null");
        this.queryExecutionInfo = Assert.requireNonNull(queryExecutionInfo, "queryExecutionInfo must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if ("unwrap".equals(methodName)) {
            return this.row;
        }
        if ("unwrapConnection".equals(methodName)) {
            return connectionInfo.getOriginalConnection();
        }
        ResultRowConverter.GetOperation onGet = () -> {
            try {
                Object result = this.proceedExecution(method, this.row, args, this.proxyConfig.getListeners(), connectionInfo, null);
                return result;
            }
            catch (Throwable throwable) {
                throw new R2dbcProxyException("Failed to perform " + methodName, throwable);
            }
        };
        Object result = this.proxyConfig.getResultRowConverter().onGet((Row)proxy, method, args, onGet);
        return result;
    }
}

