/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.support;

import io.r2dbc.proxy.core.Binding;
import io.r2dbc.proxy.core.BoundValue;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.ExecutionType;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.core.QueryInfo;
import io.r2dbc.proxy.support.FormatterUtils;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QueryExecutionInfoFormatter
implements Function<QueryExecutionInfo, String> {
    private static final String DEFAULT_DELIMITER = " ";
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onThread = (executionInfo, sb) -> {
        sb.append("Thread:");
        sb.append(executionInfo.getThreadName());
        sb.append("(");
        sb.append(executionInfo.getThreadId());
        sb.append(")");
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onConnection = (executionInfo, sb) -> {
        sb.append("Connection:");
        sb.append(executionInfo.getConnectionInfo().getConnectionId());
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onTransactionInfo = (executionInfo, sb) -> {
        sb.append("Transaction:");
        ConnectionInfo connectionInfo = executionInfo.getConnectionInfo();
        sb.append("{Create:");
        sb.append(connectionInfo.getTransactionCount());
        sb.append(" Rollback:");
        sb.append(connectionInfo.getRollbackCount());
        sb.append(" Commit:");
        sb.append(connectionInfo.getCommitCount());
        sb.append("}");
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onSuccess = (executionInfo, sb) -> {
        sb.append("Success:");
        sb.append(executionInfo.isSuccess() ? "True" : "False");
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onTime = (executionInfo, sb) -> {
        sb.append("Time:");
        sb.append(executionInfo.getExecuteDuration().toMillis());
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onType = (executionInfo, sb) -> {
        sb.append("Type:");
        sb.append(executionInfo.getType() == ExecutionType.BATCH ? "Batch" : "Statement");
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onBatchSize = (executionInfo, sb) -> {
        sb.append("BatchSize:");
        sb.append(executionInfo.getBatchSize());
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onBindingsSize = (executionInfo, sb) -> {
        sb.append("BindingsSize:");
        sb.append(executionInfo.getBindingsSize());
    };
    private final BiConsumer<QueryExecutionInfo, StringBuilder> onQuery = (executionInfo, sb) -> {
        sb.append("Query:[");
        List<QueryInfo> queries = executionInfo.getQueries();
        if (!queries.isEmpty()) {
            String s = queries.stream().map(QueryInfo::getQuery).collect(Collectors.joining("\",\"", "\"", "\""));
            sb.append(s);
        }
        sb.append("]");
    };
    public BiConsumer<BoundValue, StringBuilder> onBoundValue = (boundValue, sb) -> {
        if (boundValue.isNull()) {
            Class<?> type = boundValue.getNullType();
            sb.append("null(");
            sb.append(type.getSimpleName());
            sb.append(")");
        } else {
            Object value = boundValue.getValue();
            if (value instanceof Parameter) {
                this.onBoundValueParameter.accept((Parameter)value, (StringBuilder)sb);
            } else {
                this.onBoundValueRaw.accept(value, (StringBuilder)sb);
            }
        }
    };
    public BiConsumer<Object, StringBuilder> onBoundValueRaw = (value, sb) -> {
        if (value instanceof Clob) {
            sb.append("<clob>");
        } else if (value instanceof Blob) {
            sb.append("<blob>");
        } else {
            sb.append(value);
        }
    };
    public BiConsumer<Parameter, StringBuilder> onBoundValueParameter = (parameter, sb) -> {
        this.onBoundValueRaw.accept(parameter.getValue(), (StringBuilder)sb);
        Type type = parameter.getType();
        boolean isEnum = type instanceof Enum;
        String typeStr = isEnum ? type.toString() : type.getJavaType().getSimpleName();
        sb.append("(");
        if (parameter instanceof Parameter.In) {
            sb.append("in,");
        } else if (parameter instanceof Parameter.Out) {
            sb.append("out,");
        }
        sb.append(typeStr);
        sb.append(")");
    };
    public BiConsumer<SortedSet<Binding>, StringBuilder> onIndexBindings = (indexBindings, sb) -> {
        String s = indexBindings.stream().map(Binding::getBoundValue).map(boundValue -> {
            StringBuilder sbuilder = new StringBuilder();
            this.onBoundValue.accept((BoundValue)boundValue, sbuilder);
            return sbuilder.toString();
        }).collect(Collectors.joining(","));
        sb.append(s);
    };
    public BiConsumer<SortedSet<Binding>, StringBuilder> onNamedBindings = (namedBindings, sb) -> {
        String s = namedBindings.stream().map(binding -> {
            StringBuilder sbuilder = new StringBuilder();
            sbuilder.append(binding.getKey());
            sbuilder.append("=");
            this.onBoundValue.accept(binding.getBoundValue(), sbuilder);
            return sbuilder.toString();
        }).collect(Collectors.joining(","));
        sb.append(s);
    };
    public BiConsumer<QueryExecutionInfo, StringBuilder> onBindings = (executionInfo, sb) -> {
        sb.append("Bindings:[");
        List<QueryInfo> queries = executionInfo.getQueries();
        if (!queries.isEmpty()) {
            String s = queries.stream().map(QueryInfo::getBindingsList).filter(bindings -> !bindings.isEmpty()).map(bindings -> bindings.stream().map(binds -> {
                SortedSet<Binding> namedBindings;
                StringBuilder sbForBindings = new StringBuilder();
                SortedSet<Binding> indexBindings = binds.getIndexBindings();
                if (!indexBindings.isEmpty()) {
                    this.onIndexBindings.accept(indexBindings, sbForBindings);
                }
                if (!(namedBindings = binds.getNamedBindings()).isEmpty()) {
                    this.onNamedBindings.accept(namedBindings, sbForBindings);
                }
                return sbForBindings.toString();
            }).collect(Collectors.joining("),(", "(", ")"))).collect(Collectors.joining(","));
            sb.append(s);
        }
        sb.append("]");
    };
    private BiConsumer<QueryExecutionInfo, StringBuilder> newLine = (executionInfo, sb) -> sb.append(System.lineSeparator());
    private String delimiter = " ";
    private List<BiConsumer<QueryExecutionInfo, StringBuilder>> consumers = new ArrayList<BiConsumer<QueryExecutionInfo, StringBuilder>>();

    public QueryExecutionInfoFormatter() {
    }

    private QueryExecutionInfoFormatter(QueryExecutionInfoFormatter formatter) {
        this.newLine = formatter.newLine;
        this.delimiter = formatter.delimiter;
        this.consumers.addAll(formatter.consumers);
    }

    public static QueryExecutionInfoFormatter showAll() {
        QueryExecutionInfoFormatter formatter = new QueryExecutionInfoFormatter();
        formatter.addConsumer(formatter.onThread);
        formatter.addConsumer(formatter.onConnection);
        formatter.addConsumer(formatter.onTransactionInfo);
        formatter.addConsumer(formatter.onSuccess);
        formatter.addConsumer(formatter.onTime);
        formatter.addConsumer(formatter.onType);
        formatter.addConsumer(formatter.onBatchSize);
        formatter.addConsumer(formatter.onBindingsSize);
        formatter.addConsumer(formatter.onQuery);
        formatter.addConsumer(formatter.onBindings);
        return formatter;
    }

    public QueryExecutionInfoFormatter addConsumer(BiConsumer<QueryExecutionInfo, StringBuilder> consumer) {
        Assert.requireNonNull(consumer, "consumer must not be null");
        this.consumers.add(consumer);
        return new QueryExecutionInfoFormatter(this);
    }

    public String format(QueryExecutionInfo executionInfo) {
        Assert.requireNonNull(executionInfo, "executionInfo must not be null");
        StringBuilder sb = new StringBuilder();
        this.consumers.forEach(consumer -> {
            consumer.accept(executionInfo, sb);
            if (consumer != this.newLine) {
                sb.append(this.delimiter);
            }
        });
        FormatterUtils.chompIfEndWith(sb, this.delimiter);
        return sb.toString();
    }

    @Override
    public String apply(QueryExecutionInfo executionInfo) {
        return this.format(executionInfo);
    }

    public QueryExecutionInfoFormatter delimiter(String delimiter) {
        this.delimiter = Assert.requireNonNull(delimiter, "delimiter must not be null");
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showThread() {
        this.consumers.add(this.onThread);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showConnection() {
        this.consumers.add(this.onConnection);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showTransaction() {
        this.consumers.add(this.onTransactionInfo);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showSuccess() {
        this.consumers.add(this.onSuccess);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showTime() {
        this.consumers.add(this.onTime);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showType() {
        this.consumers.add(this.onType);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showBatchSize() {
        this.consumers.add(this.onBatchSize);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showBindingsSize() {
        this.consumers.add(this.onBindingsSize);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showQuery() {
        this.consumers.add(this.onQuery);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter showBindings() {
        this.consumers.add(this.onBindings);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter newLine() {
        this.consumers.add(this.newLine);
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter boundValue(BiConsumer<BoundValue, StringBuilder> onBoundValue) {
        this.onBoundValue = Assert.requireNonNull(onBoundValue, "onBoundValue must not be null");
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter indexBindings(BiConsumer<SortedSet<Binding>, StringBuilder> onIndexBindings) {
        this.onIndexBindings = Assert.requireNonNull(onIndexBindings, "onIndexBindings must not be null");
        return new QueryExecutionInfoFormatter(this);
    }

    public QueryExecutionInfoFormatter namedBindings(BiConsumer<SortedSet<Binding>, StringBuilder> onNamedBindings) {
        this.onNamedBindings = Assert.requireNonNull(onNamedBindings, "onNamedBindings must not be null");
        return new QueryExecutionInfoFormatter(this);
    }
}

