/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy;

import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.MethodExecutionInfo;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.listener.LifeCycleExecutionListener;
import io.r2dbc.proxy.listener.LifeCycleListener;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.ConnectionFactory;
import java.util.function.Consumer;

public final class ProxyConnectionFactory {
    private ProxyConnectionFactory() {
    }

    public static Builder builder(ConnectionFactory connectionFactory) {
        Assert.requireNonNull(connectionFactory, "connectionFactory must not be null");
        return new Builder(connectionFactory);
    }

    public static Builder builder(ConnectionFactory connectionFactory, ProxyConfig proxyConfig) {
        Assert.requireNonNull(connectionFactory, "connectionFactory must not be null");
        Assert.requireNonNull(proxyConfig, "proxyConfig must not be null");
        return ProxyConnectionFactory.builder(connectionFactory).proxyConfig(proxyConfig);
    }

    public static final class Builder {
        private final ConnectionFactory connectionFactory;
        private ProxyConfig proxyConfig = new ProxyConfig();

        private Builder(ConnectionFactory connectionFactory) {
            this.connectionFactory = Assert.requireNonNull(connectionFactory, "connectionFactory must not be null");
        }

        public ConnectionFactory build() {
            return this.proxyConfig.getProxyFactory().wrapConnectionFactory(this.connectionFactory);
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = Assert.requireNonNull(proxyConfig, "proxyConfig must not be null");
            return this;
        }

        public Builder onBeforeMethod(final Consumer<MethodExecutionInfo> consumer) {
            Assert.requireNonNull(consumer, "consumer must not be null");
            this.proxyConfig.addListener(new ProxyExecutionListener(){

                @Override
                public void beforeMethod(MethodExecutionInfo executionInfo) {
                    consumer.accept(executionInfo);
                }
            });
            return this;
        }

        public Builder onAfterMethod(final Consumer<MethodExecutionInfo> consumer) {
            Assert.requireNonNull(consumer, "consumer must not be null");
            this.proxyConfig.addListener(new ProxyExecutionListener(){

                @Override
                public void afterMethod(MethodExecutionInfo executionInfo) {
                    consumer.accept(executionInfo);
                }
            });
            return this;
        }

        public Builder onBeforeQuery(final Consumer<QueryExecutionInfo> consumer) {
            Assert.requireNonNull(consumer, "consumer must not be null");
            this.proxyConfig.addListener(new ProxyExecutionListener(){

                @Override
                public void beforeQuery(QueryExecutionInfo executionInfo) {
                    consumer.accept(executionInfo);
                }
            });
            return this;
        }

        public Builder onAfterQuery(final Consumer<QueryExecutionInfo> consumer) {
            Assert.requireNonNull(consumer, "consumer must not be null");
            this.proxyConfig.addListener(new ProxyExecutionListener(){

                @Override
                public void afterQuery(QueryExecutionInfo executionInfo) {
                    consumer.accept(executionInfo);
                }
            });
            return this;
        }

        public Builder onEachQueryResult(final Consumer<QueryExecutionInfo> consumer) {
            Assert.requireNonNull(consumer, "consumer must not be null");
            this.proxyConfig.addListener(new ProxyExecutionListener(){

                @Override
                public void eachQueryResult(QueryExecutionInfo executionInfo) {
                    consumer.accept(executionInfo);
                }
            });
            return this;
        }

        public Builder listener(ProxyExecutionListener listener) {
            Assert.requireNonNull(listener, "listener must not be null");
            this.proxyConfig.addListener(listener);
            return this;
        }

        @Deprecated
        public Builder listener(LifeCycleListener lifeCycleListener) {
            Assert.requireNonNull(lifeCycleListener, "lifeCycleListener must not be null");
            this.listener(LifeCycleExecutionListener.of(lifeCycleListener));
            return this;
        }
    }
}

