/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.StopWatch;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.spi.Result;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;

class QueryInvocationSubscriber
implements CoreSubscriber<Result>,
Subscription,
Scannable,
Fuseable.QueueSubscription<Result> {
    private final CoreSubscriber<? super Result> delegate;
    private final MutableQueryExecutionInfo executionInfo;
    private final ProxyExecutionListener listener;
    private final StopWatch stopWatch;
    private Subscription subscription;

    public QueryInvocationSubscriber(CoreSubscriber<? super Result> delegate, MutableQueryExecutionInfo executionInfo, ProxyConfig proxyConfig) {
        this.delegate = delegate;
        this.executionInfo = executionInfo;
        this.listener = proxyConfig.getListeners();
        this.stopWatch = new StopWatch(proxyConfig.getClock());
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.beforeQuery();
        this.delegate.onSubscribe((Subscription)this);
    }

    public void onNext(Result result) {
        this.executionInfo.setSuccess(true);
        this.delegate.onNext((Object)result);
    }

    public void onError(Throwable t) {
        this.executionInfo.setThrowable(t);
        this.executionInfo.setSuccess(false);
        this.afterQuery();
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.executionInfo.setSuccess(true);
        this.afterQuery();
        this.delegate.onComplete();
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.afterQuery();
        this.subscription.cancel();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL) {
            return this.delegate;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        return null;
    }

    public int requestFusion(int requestedMode) {
        return 0;
    }

    public Result poll() {
        return null;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public void clear() {
    }

    private void beforeQuery() {
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setCurrentMappedResult(null);
        this.executionInfo.setProxyEventType(ProxyEventType.BEFORE_QUERY);
        this.stopWatch.start();
        this.listener.beforeQuery(this.executionInfo);
    }

    private void afterQuery() {
        this.executionInfo.setExecuteDuration(this.stopWatch.getElapsedDuration());
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setCurrentMappedResult(null);
        this.executionInfo.setProxyEventType(ProxyEventType.AFTER_QUERY);
        this.listener.afterQuery(this.executionInfo);
    }
}

