/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandler;
import io.r2dbc.proxy.callback.MutableMethodExecutionInfo;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.ProxyFactory;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.MethodExecutionInfo;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.listener.CompositeProxyExecutionListener;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Result;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

abstract class CallbackHandlerSupport
implements CallbackHandler {
    protected static final MethodInvocationStrategy DEFAULT_INVOCATION_STRATEGY = (method, target, args) -> {
        Object result;
        try {
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        return result;
    };
    private static final Set<Method> PASS_THROUGH_METHODS;
    protected final ProxyConfig proxyConfig;
    protected MethodInvocationStrategy methodInvocationStrategy = DEFAULT_INVOCATION_STRATEGY;

    public CallbackHandlerSupport(ProxyConfig proxyConfig) {
        this.proxyConfig = Assert.requireNonNull(proxyConfig, "proxyConfig must not be null");
    }

    protected Object proceedExecution(Method method, Object target, Object[] args, ProxyExecutionListener listener, ConnectionInfo connectionInfo, @Nullable BiFunction<Object, MutableMethodExecutionInfo, Object> onMap, @Nullable Consumer<MethodExecutionInfo> onComplete) throws Throwable {
        Assert.requireNonNull(method, "method must not be null");
        Assert.requireNonNull(target, "target must not be null");
        Assert.requireNonNull(listener, "listener must not be null");
        if (PASS_THROUGH_METHODS.contains(method)) {
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        if ("toString".equals(method.getName())) {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getSimpleName());
            sb.append("-proxy [");
            sb.append(target.toString());
            sb.append("]");
            return sb.toString();
        }
        StopWatch stopWatch = new StopWatch(this.proxyConfig.getClock());
        MutableMethodExecutionInfo executionInfo = new MutableMethodExecutionInfo();
        executionInfo.setMethod(method);
        executionInfo.setMethodArgs(args);
        executionInfo.setTarget(target);
        executionInfo.setConnectionInfo(connectionInfo);
        Class<?> returnType = method.getReturnType();
        if (Publisher.class.isAssignableFrom(returnType)) {
            Publisher result = (Publisher)this.methodInvocationStrategy.invoke(method, target, args);
            return Flux.empty().doOnSubscribe(s -> {
                executionInfo.setThreadName(Thread.currentThread().getName());
                executionInfo.setThreadId(Thread.currentThread().getId());
                executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
                listener.beforeMethod(executionInfo);
                stopWatch.start();
            }).concatWith(result).map(resultObj -> {
                executionInfo.setResult(resultObj);
                if (onMap != null) {
                    return onMap.apply(resultObj, executionInfo);
                }
                return resultObj;
            }).doOnComplete(() -> {
                if (onComplete != null) {
                    onComplete.accept(executionInfo);
                }
            }).doOnError(throwable -> executionInfo.setThrown((Throwable)throwable)).doFinally(signalType -> {
                executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
                executionInfo.setThreadName(Thread.currentThread().getName());
                executionInfo.setThreadId(Thread.currentThread().getId());
                executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
                listener.afterMethod(executionInfo);
            });
        }
        executionInfo.setThreadName(Thread.currentThread().getName());
        executionInfo.setThreadId(Thread.currentThread().getId());
        executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
        listener.beforeMethod(executionInfo);
        stopWatch.start();
        Object result = null;
        Throwable thrown = null;
        try {
            result = this.methodInvocationStrategy.invoke(method, target, args);
            executionInfo.setResult(result);
            executionInfo.setThrown(thrown);
            executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
            executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
            listener.afterMethod(executionInfo);
        }
        catch (Throwable ex) {
            try {
                thrown = ex;
                throw thrown;
            }
            catch (Throwable throwable2) {
                executionInfo.setResult(result);
                executionInfo.setThrown(thrown);
                executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
                executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
                listener.afterMethod(executionInfo);
                throw throwable2;
            }
        }
        return result;
    }

    protected Flux<? extends Result> interceptQueryExecution(Publisher<? extends Result> flux, MutableQueryExecutionInfo executionInfo) {
        Assert.requireNonNull(flux, "flux must not be null");
        Assert.requireNonNull(executionInfo, "executionInfo must not be null");
        CompositeProxyExecutionListener listener = this.proxyConfig.getListeners();
        StopWatch stopWatch = new StopWatch(this.proxyConfig.getClock());
        Flux queryExecutionFlux = Flux.empty().ofType(Result.class).doOnSubscribe(s -> {
            executionInfo.setThreadName(Thread.currentThread().getName());
            executionInfo.setThreadId(Thread.currentThread().getId());
            executionInfo.setCurrentMappedResult(null);
            executionInfo.setProxyEventType(ProxyEventType.BEFORE_QUERY);
            listener.beforeQuery(executionInfo);
            stopWatch.start();
        }).concatWith(flux).doOnComplete(() -> executionInfo.setSuccess(true)).doOnError(throwable -> {
            executionInfo.setThrowable((Throwable)throwable);
            executionInfo.setSuccess(false);
        }).doFinally(signalType -> {
            executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
            executionInfo.setThreadName(Thread.currentThread().getName());
            executionInfo.setThreadId(Thread.currentThread().getId());
            executionInfo.setCurrentMappedResult(null);
            executionInfo.setProxyEventType(ProxyEventType.AFTER_QUERY);
            listener.afterQuery(executionInfo);
        });
        ProxyFactory proxyFactory = this.proxyConfig.getProxyFactory();
        return Flux.from((Publisher)queryExecutionFlux).flatMap(queryResult -> Mono.just((Object)proxyFactory.wrapResult((Result)queryResult, executionInfo)));
    }

    public void setMethodInvocationStrategy(MethodInvocationStrategy methodInvocationStrategy) {
        this.methodInvocationStrategy = Assert.requireNonNull(methodInvocationStrategy, "methodInvocationStrategy must not be null");
    }

    static {
        try {
            Method objectToStringMethod = Object.class.getMethod("toString", new Class[0]);
            PASS_THROUGH_METHODS = Arrays.stream(Object.class.getMethods()).filter(method -> !objectToStringMethod.equals(method)).collect(Collectors.toSet());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StopWatch {
        private Clock clock;
        private Instant startTime;

        private StopWatch(Clock clock) {
            this.clock = clock;
        }

        public StopWatch start() {
            this.startTime = this.clock.instant();
            return this;
        }

        public Duration getElapsedDuration() {
            return Duration.between(this.startTime, this.clock.instant());
        }
    }

    @FunctionalInterface
    public static interface MethodInvocationStrategy {
        public Object invoke(Method var1, Object var2, Object[] var3) throws Throwable;
    }
}

