/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class ShortCodec
extends AbstractNumericCodec<Short> {
    private final ByteBufAllocator byteBufAllocator;

    ShortCodec(ByteBufAllocator byteBufAllocator) {
        super(Short.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return ShortCodec.createNull(PostgresqlObjectId.INT2, Format.FORMAT_BINARY);
    }

    @Override
    Short doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, @Nullable Class<? extends Short> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Short.class, Number::shortValue);
    }

    @Override
    Parameter doEncode(Short value) {
        Assert.requireNonNull(value, "value must not be null");
        return ShortCodec.create(PostgresqlObjectId.INT2, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(2).writeShort((int)value.shortValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.INT2;
    }
}

