/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Path;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import java.util.ArrayList;
import java.util.List;

final class PathCodec
extends AbstractGeometryCodec<Path> {
    PathCodec(ByteBufAllocator byteBufAllocator) {
        super(Path.class, PostgresqlObjectId.PATH, byteBufAllocator);
    }

    @Override
    Path doDecodeBinary(ByteBuf byteBuffer) {
        boolean closed = byteBuffer.readBoolean();
        int size = byteBuffer.readInt();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            points.add(Point.of(byteBuffer.readDouble(), byteBuffer.readDouble()));
        }
        return Path.of(!closed, points);
    }

    @Override
    Path doDecodeText(String text) {
        boolean open = text.startsWith("[");
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        ArrayList<Point> points = new ArrayList<Point>();
        while (stream.hasNext()) {
            points.add(Point.of(stream.nextDouble(), stream.nextDouble()));
        }
        return Path.of(open, points);
    }

    @Override
    ByteBuf doEncodeBinary(Path value) {
        List<Point> points = value.getPoints();
        ByteBuf buffer = this.byteBufAllocator.buffer(points.size() * 16 + 5).writeBoolean(!value.isOpen()).writeInt(points.size());
        points.forEach(point -> buffer.writeDouble(point.getX()).writeDouble(point.getY()));
        return buffer;
    }
}

