/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import io.r2dbc.spi.Clob;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class ClobCodec
extends AbstractCodec<Clob> {
    private final ByteBufAllocator byteBufAllocator;

    ClobCodec(ByteBufAllocator byteBufAllocator) {
        super(Clob.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return ClobCodec.createNull(PostgresqlObjectId.TEXT, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.TEXT == type;
    }

    @Override
    Clob doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Clob> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return Clob.from((Publisher)Mono.just((Object)ByteBufUtils.decode(buffer)));
    }

    @Override
    Parameter doEncode(Clob value) {
        Assert.requireNonNull(value, "value must not be null");
        return ClobCodec.create(PostgresqlObjectId.VARCHAR, Format.FORMAT_TEXT, (Publisher<? extends ByteBuf>)Flux.from((Publisher)value.stream()).reduce((Object)new StringBuilder(), StringBuilder::append).map(sb -> ByteBufUtils.encode(this.byteBufAllocator, sb.toString())).concatWith((Publisher)Flux.from((Publisher)value.discard()).then(Mono.empty())));
    }
}

