/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Circle;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.type.PostgresqlObjectId;

final class CircleCodec
extends AbstractGeometryCodec<Circle> {
    CircleCodec(ByteBufAllocator byteBufAllocator) {
        super(Circle.class, PostgresqlObjectId.CIRCLE, byteBufAllocator);
    }

    @Override
    Circle doDecodeBinary(ByteBuf byteBuffer) {
        return Circle.of(Point.of(byteBuffer.readDouble(), byteBuffer.readDouble()), byteBuffer.readDouble());
    }

    @Override
    Circle doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        return Circle.of(Point.of(stream.nextDouble(), stream.nextDouble()), stream.nextDouble());
    }

    @Override
    ByteBuf doEncodeBinary(Circle value) {
        Point center = value.getCenter();
        return this.byteBufAllocator.buffer(this.lengthInBytes()).writeDouble(center.getX()).writeDouble(center.getY()).writeDouble(value.getRadius());
    }

    int lengthInBytes() {
        return 24;
    }
}

