/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor;

import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.BeanParamInfo;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ArrayConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.CharParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.CharacterParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.InstantParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ListConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LoadedParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LocalDateParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LocalDateTimeParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LocalTimeParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.NoopParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.OffsetDateTimeParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.OffsetTimeParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.OptionalConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.PathSegmentParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.SetConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.SortedSetConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.YearMonthParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.YearParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ZonedDateTimeParamConverter;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.EndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.processor.ReflectionEndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.jboss.resteasy.reactive.server.processor.reflection.ReflectionConverterIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonArrayHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonObjectHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonStructureHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonValueHandler;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;

public class ServerEndpointIndexer
extends EndpointIndexer<ServerEndpointIndexer, ServerIndexedParameter, ServerResourceMethod> {
    private static final DotName FILE_DOT_NAME = DotName.createSimple((String)File.class.getName());
    private static final DotName PATH_DOT_NAME = DotName.createSimple((String)Path.class.getName());
    private static final DotName FILEUPLOAD_DOT_NAME = DotName.createSimple((String)FileUpload.class.getName());
    private static final Set<DotName> SUPPORTED_MULTIPART_FILE_TYPES = Set.of(FILE_DOT_NAME, PATH_DOT_NAME, FILEUPLOAD_DOT_NAME);
    protected final EndpointInvokerFactory endpointInvokerFactory;
    protected final List<MethodScanner> methodScanners;
    protected final FieldInjectionIndexerExtension fieldInjectionHandler;
    protected final ConverterSupplierIndexerExtension converterSupplierIndexerExtension;
    protected final boolean removesTrailingSlash;

    protected ServerEndpointIndexer(AbstractBuilder builder) {
        super((EndpointIndexer.Builder)builder);
        this.endpointInvokerFactory = builder.endpointInvokerFactory;
        this.methodScanners = new ArrayList<MethodScanner>(builder.methodScanners);
        this.fieldInjectionHandler = builder.fieldInjectionIndexerExtension;
        this.converterSupplierIndexerExtension = builder.converterSupplierIndexerExtension;
        this.removesTrailingSlash = builder.removesTrailingSlash;
    }

    protected void addWriterForType(AdditionalWriters additionalWriters, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalWriters.add(ServerJsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalWriters.add(ServerJsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalWriters.add(ServerJsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalWriters.add(ServerJsonStructureHandler.class, "application/json", JsonStructure.class);
        }
    }

    protected void addReaderForType(AdditionalReaders additionalReaders, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalReaders.add(ServerJsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalReaders.add(ServerJsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalReaders.add(ServerJsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalReaders.add(ServerJsonStructureHandler.class, "application/json", JsonStructure.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.MULTI_VALUED_MAP)) {
            additionalReaders.add(ServerFormUrlEncodedProvider.class, "application/x-www-form-urlencoded", MultivaluedMap.class);
        }
    }

    protected ServerIndexedParameter createIndexedParam() {
        return new ServerIndexedParameter();
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ServerIndexedParameter builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        for (MethodScanner i : this.methodScanners) {
            ParameterExtractor res = i.handleCustomParameter(paramType, anns, field, methodContext);
            if (res == null) continue;
            builder.setType(ParameterType.CUSTOM);
            builder.setCustomParameterExtractor(res);
            return true;
        }
        return false;
    }

    protected ServerResourceMethod createResourceMethod(MethodInfo methodInfo, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        ServerResourceMethod serverResourceMethod = new ServerResourceMethod();
        ArrayList<HandlerChainCustomizer> methodCustomizers = new ArrayList<HandlerChainCustomizer>();
        for (MethodScanner i : this.methodScanners) {
            List<HandlerChainCustomizer> scanned = i.scan(methodInfo, actualEndpointClass, methodContext);
            if (scanned == null) continue;
            methodCustomizers.addAll(scanned);
        }
        serverResourceMethod.setHandlerChainCustomizers(methodCustomizers);
        String actualDeclaringClassName = this.findActualDeclaringClassName(methodInfo, actualEndpointClass);
        serverResourceMethod.setActualDeclaringClassName(actualDeclaringClassName);
        String classDeclMethodThatHasJaxRsEndpointDefiningAnn = methodInfo.declaringClass().name().toString();
        if (!actualDeclaringClassName.equals(classDeclMethodThatHasJaxRsEndpointDefiningAnn)) {
            serverResourceMethod.setClassDeclMethodThatHasJaxRsEndpointDefiningAnn(classDeclMethodThatHasJaxRsEndpointDefiningAnn);
        }
        return serverResourceMethod;
    }

    private String findActualDeclaringClassName(MethodInfo methodInfo, ClassInfo actualEndpointClass) {
        return ServerEndpointIndexer.findEndpointImplementation(methodInfo, actualEndpointClass, this.index).declaringClass().name().toString();
    }

    public static MethodInfo findEndpointImplementation(MethodInfo methodInfo, ClassInfo actualEndpointClass, IndexView index) {
        ClassInfo clazz = null;
        if (actualEndpointClass.isInterface()) {
            for (ClassInfo implementor : index.getAllKnownImplementors(actualEndpointClass.name())) {
                if (implementor.isInterface() || implementor.isAbstract()) continue;
                if (clazz == null) {
                    clazz = implementor;
                    continue;
                }
                clazz = actualEndpointClass;
                break;
            }
        } else {
            for (ClassInfo subClass : index.getAllKnownSubclasses(actualEndpointClass.name())) {
                if (subClass.isAbstract()) continue;
                if (clazz == null) {
                    clazz = subClass;
                    continue;
                }
                clazz = actualEndpointClass;
                break;
            }
        }
        if (clazz == null) {
            clazz = actualEndpointClass;
        }
        ArrayDeque<MethodInfo> defaultInterfaceMethods = new ArrayDeque<MethodInfo>();
        do {
            MethodInfo method;
            if ((method = clazz.method(methodInfo.name(), methodInfo.parameterTypes())) != null && !Modifier.isAbstract(method.flags())) {
                return method;
            }
            MethodInfo interfaceWithImplMethod = ServerEndpointIndexer.findInterfaceDefaultMethod(clazz, methodInfo, index);
            if (interfaceWithImplMethod == null) continue;
            defaultInterfaceMethods.add(interfaceWithImplMethod);
        } while (clazz.superName() != null && !clazz.superName().equals((Object)ResteasyReactiveDotNames.OBJECT) && (clazz = index.getClassByName(clazz.superName())) != null);
        if (!defaultInterfaceMethods.isEmpty()) {
            return (MethodInfo)defaultInterfaceMethods.peek();
        }
        return methodInfo;
    }

    private static MethodInfo findInterfaceDefaultMethod(ClassInfo clazz, MethodInfo methodInfo, IndexView index) {
        for (DotName interfaceName : clazz.interfaceNames()) {
            MethodInfo intMethod;
            ClassInfo interfaceClass = index.getClassByName(interfaceName);
            if (interfaceClass == null || (intMethod = interfaceClass.method(methodInfo.name(), methodInfo.parameterTypes())) == null || !intMethod.isDefault() || !Modifier.isPublic(intMethod.flags())) continue;
            return intMethod;
        }
        return null;
    }

    protected boolean handleBeanParam(ClassInfo actualEndpointInfo, Type paramType, MethodParameter[] methodParameters, int i, Set<String> fileFormNames) {
        ClassInfo beanParamClassInfo = this.index.getClassByName(paramType.name());
        InjectableBean injectableBean = this.scanInjectableBean(beanParamClassInfo, actualEndpointInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
        if (injectableBean.getFieldExtractorsCount() == 0 && !injectableBean.isInjectionRequired()) {
            throw new DeploymentException(String.format("No annotations found on fields at '%s'. Annotations like `@QueryParam` should be used in fields, not in methods.", beanParamClassInfo.name()));
        }
        fileFormNames.addAll(injectableBean.getFileFormNames());
        return injectableBean.isFormParamRequired();
    }

    protected boolean doesMethodHaveBlockingSignature(MethodInfo info) {
        for (MethodScanner i : this.methodScanners) {
            if (!i.isMethodSignatureAsync(info)) continue;
            return false;
        }
        return true;
    }

    protected void handleAdditionalMethodProcessing(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
        HandlerChainCustomizer i;
        Supplier<EndpointInvoker> invokerSupplier = null;
        Iterator iterator = method.getHandlerChainCustomizers().iterator();
        while (iterator.hasNext() && (invokerSupplier = (i = (HandlerChainCustomizer)iterator.next()).alternateInvoker(method)) == null) {
        }
        if (invokerSupplier == null) {
            invokerSupplier = this.endpointInvokerFactory.create((ResourceMethod)method, currentClassInfo, info);
        }
        method.setInvoker(invokerSupplier);
        HashSet<String> methodAnnotationNames = new HashSet<String>();
        Collection instances = annotationStore.getAnnotations((AnnotationTarget)info);
        for (AnnotationInstance instance : instances) {
            methodAnnotationNames.add(instance.name().toString());
        }
        method.setMethodAnnotationNames(methodAnnotationNames);
        this.validateMethodPath(method, currentClassInfo, info);
    }

    private void validateMethodPath(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info) {
        try {
            new URITemplate(method.getPath(), false);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Path '" + method.getPath() + "' of method '" + String.valueOf(currentClassInfo.name()) + "#" + info.name() + "' is not a valid expression", e);
        }
    }

    protected InjectableBean scanInjectableBean(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<String, InjectableBean> injectableBeans, boolean hasRuntimeConverters) {
        ClassInfo superClass;
        String currentTypeName = currentClassInfo.name().toString();
        InjectableBean currentInjectableBean = injectableBeans.get(currentTypeName);
        if (currentInjectableBean != null) {
            return currentInjectableBean;
        }
        currentInjectableBean = new BeanParamInfo();
        injectableBeans.put(currentTypeName, currentInjectableBean);
        this.validateMethodsForInjectableBean(currentClassInfo);
        LinkedHashMap<FieldInfo, ServerIndexedParameter> fieldExtractors = new LinkedHashMap<FieldInfo, ServerIndexedParameter>();
        LinkedHashMap<FieldInfo, ServerIndexedParameter> beanParamFields = new LinkedHashMap<FieldInfo, ServerIndexedParameter>();
        boolean applyFieldRules = !currentClassInfo.isRecord();
        for (FieldInfo field : currentClassInfo.fields()) {
            AnnotationValue value;
            HashMap<DotName, AnnotationInstance> annotations = new HashMap<DotName, AnnotationInstance>();
            for (AnnotationInstance i : field.annotations()) {
                annotations.put(i.name(), i);
            }
            ServerIndexedParameter result = (ServerIndexedParameter)this.extractParameterInfo(currentClassInfo, actualEndpointInfo, null, existingConverters, additionalReaders, annotations, field.type(), field.toString(), applyFieldRules, hasRuntimeConverters, Collections.emptySet(), field.name(), EMPTY_STRING_ARRAY, new HashMap());
            if (result.getType() != null && result.getType() != ParameterType.BEAN) {
                fieldExtractors.put(field, result);
            }
            if (result.getType() == ParameterType.BEAN) {
                beanParamFields.put(field, result);
                ClassInfo beanParamClassInfo = this.index.getClassByName(field.type().name());
                InjectableBean injectableBean = this.scanInjectableBean(beanParamClassInfo, actualEndpointInfo, existingConverters, additionalReaders, injectableBeans, hasRuntimeConverters);
                if (!injectableBean.isFormParamRequired()) continue;
                currentInjectableBean.setFormParamRequired(true);
                continue;
            }
            if (result.getType() != ParameterType.FORM) continue;
            currentInjectableBean.setFormParamRequired(true);
            if (!SUPPORTED_MULTIPART_FILE_TYPES.contains(field.type().name())) continue;
            String name = field.name();
            AnnotationInstance restForm = field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
            AnnotationInstance formParam = field.annotation(ResteasyReactiveDotNames.FORM_PARAM);
            if (restForm != null) {
                value = restForm.value();
                if (value != null) {
                    name = value.asString();
                }
            } else if (formParam != null && (value = formParam.value()) != null) {
                name = value.asString();
            }
            currentInjectableBean.getFileFormNames().add(name);
        }
        fieldExtractors.putAll(beanParamFields);
        DotName superClassName = currentClassInfo.superName();
        boolean superTypeIsInjectable = false;
        if (superClassName != null && !superClassName.equals((Object)ResteasyReactiveDotNames.OBJECT) && !superClassName.equals((Object)ResteasyReactiveDotNames.RECORD) && (superClass = this.index.getClassByName(superClassName)) != null) {
            InjectableBean superInjectableBean = this.scanInjectableBean(superClass, actualEndpointInfo, existingConverters, additionalReaders, injectableBeans, hasRuntimeConverters);
            superTypeIsInjectable = superInjectableBean.isInjectionRequired();
            if (superInjectableBean.isFormParamRequired()) {
                currentInjectableBean.setFormParamRequired(true);
            }
        }
        currentInjectableBean.setFieldExtractorsCount(fieldExtractors.size());
        if (this.fieldInjectionHandler != null && (!fieldExtractors.isEmpty() || superTypeIsInjectable)) {
            this.fieldInjectionHandler.handleFieldInjection(currentTypeName, fieldExtractors, superTypeIsInjectable, this.index);
        }
        currentInjectableBean.setInjectionRequired(!fieldExtractors.isEmpty() || superTypeIsInjectable);
        return currentInjectableBean;
    }

    protected MethodParameter createMethodParameter(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, boolean encoded, Type paramType, ServerIndexedParameter parameterResult, String name, String defaultValue, ParameterType type, String elementType, boolean single, String signature, Set<String> fileFormNames) {
        ParameterConverterSupplier converter = parameterResult.getConverter();
        EndpointIndexer.DeclaredTypes declaredTypes = this.getDeclaredTypes(paramType, currentClassInfo, actualEndpointInfo);
        String mimeType = this.getPartMime(parameterResult.getAnns());
        String declaredType = declaredTypes.getDeclaredType();
        if (SUPPORTED_MULTIPART_FILE_TYPES.contains(DotName.createSimple((String)declaredType))) {
            fileFormNames.add(name);
        }
        return new ServerMethodParameter(name, elementType, declaredType, declaredTypes.getDeclaredUnresolvedType(), type, single, signature, converter, defaultValue, parameterResult.isObtainedAsCollection(), parameterResult.isOptional(), encoded, parameterResult.getCustomParameterExtractor(), mimeType, parameterResult.getSeparator());
    }

    protected void handleOtherParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, MethodInfo currentMethodInfo) {
        try {
            builder.setConverter(this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not create converter for " + elementType + " for " + builder.getErrorLocation() + " of type " + String.valueOf(builder.getType()), throwable);
        }
    }

    protected void handleSortedSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, MethodInfo currentMethodInfo) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
        builder.setConverter((ParameterConverterSupplier)new SortedSetConverter.SortedSetSupplier(converter));
    }

    protected void handleOptionalParam(Map<String, String> existingConverters, Map<DotName, AnnotationInstance> parameterAnnotations, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, String genericElementType, MethodInfo currentMethodInfo) {
        ParameterConverterSupplier converter = null;
        if (genericElementType != null) {
            ParameterConverterSupplier genericTypeConverter = this.extractConverter(genericElementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
            if (ResteasyReactiveDotNames.LIST.toString().equals(elementType)) {
                converter = new ListConverter.ListSupplier(genericTypeConverter);
                builder.setSingle(false);
            } else if (ResteasyReactiveDotNames.SET.toString().equals(elementType)) {
                converter = new SetConverter.SetSupplier(genericTypeConverter);
                builder.setSingle(false);
            } else if (ResteasyReactiveDotNames.SORTED_SET.toString().equals(elementType)) {
                converter = new SortedSetConverter.SortedSetSupplier(genericTypeConverter);
                builder.setSingle(false);
            }
        } else if (SUPPORT_TEMPORAL_PARAMS.contains(DotName.createSimple((String)elementType))) {
            converter = this.determineTemporalConverter(DotName.createSimple((String)elementType), parameterAnnotations, currentMethodInfo);
        }
        if (converter == null) {
            converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
        }
        builder.setConverter((ParameterConverterSupplier)new OptionalConverter.OptionalSupplier(converter));
    }

    protected void handleSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, MethodInfo currentMethodInfo) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
        builder.setConverter((ParameterConverterSupplier)new SetConverter.SetSupplier(converter));
    }

    protected void handleListParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, MethodInfo currentMethodInfo) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
        builder.setConverter((ParameterConverterSupplier)new ListConverter.ListSupplier(converter));
    }

    protected void handleArrayParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType, MethodInfo currentMethodInfo) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters, builder.getAnns(), currentMethodInfo);
        builder.setConverter((ParameterConverterSupplier)new ArrayConverter.ArraySupplier(converter, elementType));
    }

    protected void handlePathSegmentParam(ServerIndexedParameter builder) {
        builder.setConverter((ParameterConverterSupplier)new PathSegmentParamConverter.Supplier());
    }

    protected String handleTrailingSlash(String path) {
        if (this.removesTrailingSlash) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected void handleTemporalParam(ServerIndexedParameter builder, DotName paramType, Map<DotName, AnnotationInstance> parameterAnnotations, MethodInfo currentMethodInfo) {
        builder.setConverter(this.determineTemporalConverter(paramType, parameterAnnotations, currentMethodInfo));
    }

    private ParameterConverterSupplier determineTemporalConverter(DotName paramType, Map<DotName, AnnotationInstance> parameterAnnotations, MethodInfo currentMethodInfo) {
        String format = null;
        String dateTimeFormatterProviderClassName = null;
        AnnotationInstance dateFormatInstance = parameterAnnotations.get(ResteasyReactiveDotNames.DATE_FORMAT);
        if (dateFormatInstance != null) {
            AnnotationValue dateTimeFormatterProviderValue;
            AnnotationValue formatValue = dateFormatInstance.value("pattern");
            if (formatValue != null) {
                format = formatValue.asString();
            }
            if ((dateTimeFormatterProviderValue = dateFormatInstance.value("dateTimeFormatterProvider")) != null) {
                dateTimeFormatterProviderClassName = dateTimeFormatterProviderValue.asClass().name().toString();
            }
        }
        if (ResteasyReactiveDotNames.INSTANT.equals((Object)paramType)) {
            if (dateFormatInstance != null) {
                throw new RuntimeException(this.contextualizeErrorMessage("'java.time.Instant' types must not be annotated with '@DateFormat'", currentMethodInfo));
            }
            return new InstantParamConverter.Supplier();
        }
        if (format != null && dateTimeFormatterProviderClassName != null) {
            throw new RuntimeException(this.contextualizeErrorMessage("Using both 'format' and 'dateTimeFormatterProvider' is not allowed when using '@DateFormat'", currentMethodInfo));
        }
        if (format == null && dateTimeFormatterProviderClassName == null && dateFormatInstance != null) {
            throw new RuntimeException(this.contextualizeErrorMessage("One of 'format' or 'dateTimeFormatterProvider' must be set when using '@DateFormat'", currentMethodInfo));
        }
        if (ResteasyReactiveDotNames.LOCAL_DATE.equals((Object)paramType)) {
            return new LocalDateParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.LOCAL_DATE_TIME.equals((Object)paramType)) {
            return new LocalDateTimeParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.LOCAL_TIME.equals((Object)paramType)) {
            return new LocalTimeParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.OFFSET_DATE_TIME.equals((Object)paramType)) {
            return new OffsetDateTimeParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.OFFSET_TIME.equals((Object)paramType)) {
            return new OffsetTimeParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.ZONED_DATE_TIME.equals((Object)paramType)) {
            return new ZonedDateTimeParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.YEAR.equals((Object)paramType)) {
            return new YearParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        if (ResteasyReactiveDotNames.YEAR_MONTH.equals((Object)paramType)) {
            return new YearMonthParamConverter.Supplier(format, dateTimeFormatterProviderClassName);
        }
        throw new RuntimeException(this.contextualizeErrorMessage("Unable to handle temporal type '" + String.valueOf(paramType) + "'", currentMethodInfo));
    }

    private void validateMethodsForInjectableBean(ClassInfo currentClassInfo) {
        if (currentClassInfo.isRecord()) {
            return;
        }
        for (MethodInfo method : currentClassInfo.methods()) {
            for (AnnotationInstance annotation : method.annotations()) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                for (DotName annotationForField : ResteasyReactiveDotNames.JAX_RS_ANNOTATIONS_FOR_FIELDS) {
                    if (!annotation.name().equals((Object)annotationForField)) continue;
                    throw new DeploymentException(String.format("Method '%s' of class '%s' is annotated with @%s annotation which is prohibited. Classes used as @BeanParam parameters must have a JAX-RS parameter annotation on fields only.", method.name(), currentClassInfo.name().toString(), annotation.name().withoutPackagePrefix()));
                }
            }
        }
    }

    private String contextualizeErrorMessage(String errorMessage, MethodInfo currentMethodInfo) {
        errorMessage = (String)errorMessage + ". Offending method if '" + currentMethodInfo.name() + "' of class '" + String.valueOf(currentMethodInfo.declaringClass().name()) + "'";
        return errorMessage;
    }

    private ParameterConverterSupplier extractConverter(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, Map<DotName, AnnotationInstance> annotations, MethodInfo currentMethodInfo) {
        if (this.getPartMime(annotations) != null) {
            return null;
        }
        if (elementType.equals(String.class.getName())) {
            if (hasRuntimeConverters) {
                return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)new NoopParameterConverter.Supplier());
            }
            return null;
        }
        if (existingConverters.containsKey(elementType)) {
            String className = existingConverters.get(elementType);
            LoadedParameterConverter delegate = className == null ? null : new LoadedParameterConverter().setClassName(className);
            if (hasRuntimeConverters) {
                return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)delegate);
            }
            if (delegate == null) {
                throw new RuntimeException("Failed to find converter for " + elementType);
            }
            return delegate;
        }
        if (elementType.equals(PathSegment.class.getName())) {
            return new PathSegmentParamConverter.Supplier();
        }
        if (elementType.equals("char")) {
            return new CharParamConverter.Supplier();
        }
        if (elementType.equals(Character.class.getName())) {
            return new CharacterParamConverter.Supplier();
        }
        if (elementType.equals(FileUpload.class.getName()) || elementType.equals(Path.class.getName()) || elementType.equals(File.class.getName()) || elementType.equals(InputStream.class.getName())) {
            return null;
        }
        DotName typeName = DotName.createSimple((String)elementType);
        if (SUPPORT_TEMPORAL_PARAMS.contains(typeName)) {
            return this.determineTemporalConverter(typeName, annotations, currentMethodInfo);
        }
        return this.converterSupplierIndexerExtension.extractConverterImpl(elementType, indexView, existingConverters, errorLocation, hasRuntimeConverters);
    }

    public static class AbstractBuilder<B extends EndpointIndexer.Builder<ServerEndpointIndexer, B, ServerResourceMethod>>
    extends EndpointIndexer.Builder<ServerEndpointIndexer, B, ServerResourceMethod> {
        private EndpointInvokerFactory endpointInvokerFactory = new ReflectionEndpointInvokerFactory();
        private List<MethodScanner> methodScanners = new ArrayList<MethodScanner>();
        private FieldInjectionIndexerExtension fieldInjectionIndexerExtension;
        private ConverterSupplierIndexerExtension converterSupplierIndexerExtension = new ReflectionConverterIndexerExtension();
        private boolean removesTrailingSlash = true;

        public EndpointInvokerFactory getEndpointInvokerFactory() {
            return this.endpointInvokerFactory;
        }

        public B setEndpointInvokerFactory(EndpointInvokerFactory endpointInvokerFactory) {
            this.endpointInvokerFactory = endpointInvokerFactory;
            return (B)((Object)this);
        }

        public B addMethodScanner(MethodScanner methodScanner) {
            this.methodScanners.add(methodScanner);
            return (B)((Object)this);
        }

        public B setConverterSupplierIndexerExtension(ConverterSupplierIndexerExtension converterSupplierIndexerExtension) {
            this.converterSupplierIndexerExtension = converterSupplierIndexerExtension;
            return (B)((Object)this);
        }

        public B addMethodScanners(Collection<MethodScanner> methodScanners) {
            this.methodScanners.addAll(methodScanners);
            return (B)((Object)this);
        }

        public B setFieldInjectionIndexerExtension(FieldInjectionIndexerExtension fieldInjectionHandler) {
            this.fieldInjectionIndexerExtension = fieldInjectionHandler;
            return (B)((Object)this);
        }

        public B setRemovesTrailingSlash(boolean removesTrailingSlash) {
            this.removesTrailingSlash = removesTrailingSlash;
            return (B)((Object)this);
        }

        public ServerEndpointIndexer build() {
            return new ServerEndpointIndexer(this);
        }
    }

    public static interface FieldInjectionIndexerExtension {
        public void handleFieldInjection(String var1, Map<FieldInfo, ServerIndexedParameter> var2, boolean var3, IndexView var4);
    }

    public static interface ConverterSupplierIndexerExtension {
        public ParameterConverterSupplier extractConverterImpl(String var1, IndexView var2, Map<String, String> var3, String var4, boolean var5);
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
    }
}

