/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.client.impl.ClientResponseBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientResponseContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.multipart.FileDownloadImpl;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.FieldFiller;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;

public class ClientResponseCompleteRestHandler
implements ClientRestHandler {
    public void handle(RestClientRequestContext context) throws Exception {
        context.getResult().complete(ClientResponseCompleteRestHandler.mapToResponse(context, true));
    }

    public static ResponseImpl mapToResponse(RestClientRequestContext context, boolean parseContent) throws IOException {
        Map<Class<?>, MultipartResponseData> multipartDataMap = context.getMultipartResponsesData();
        ClientResponseContextImpl responseContext = context.getOrCreateClientResponseContext();
        ClientResponseBuilderImpl builder = new ClientResponseBuilderImpl();
        builder.status(responseContext.getStatus(), responseContext.getReasonPhrase());
        builder.setAllHeaders(responseContext.getHeaders());
        builder.invocationState(context);
        InputStream entityStream = responseContext.getEntityStream();
        if (context.isResponseTypeSpecified() && Response.Status.Family.familyOf((int)context.getResponseStatus()) == Response.Status.Family.SUCCESSFUL && parseContent) {
            if (context.getResponseMultipartParts() != null) {
                GenericType<?> responseType = context.getResponseType();
                if (!(responseType.getType() instanceof Class)) {
                    throw new IllegalArgumentException("Not supported return type for a multipart message, expected a non-generic class got : " + String.valueOf(responseType.getType()));
                }
                Class responseClass = (Class)responseType.getType();
                MultipartResponseData multipartData = multipartDataMap.get(responseClass);
                if (multipartData == null) {
                    throw new IllegalStateException("Failed to find multipart data for class " + String.valueOf(responseClass) + ". If it's meant to be used as multipart response type, consider annotating it with @MultipartForm");
                }
                Object result = multipartData.newInstance();
                builder.entity(result);
                List<InterfaceHttpData> parts = context.getResponseMultipartParts();
                for (InterfaceHttpData httpData : parts) {
                    FieldFiller fieldFiller = null;
                    for (FieldFiller ff : multipartData.getFieldFillers()) {
                        if (!ff.getPartName().equals(httpData.getName())) continue;
                        fieldFiller = ff;
                        break;
                    }
                    if (fieldFiller == null) continue;
                    if (httpData instanceof Attribute) {
                        Attribute at = (Attribute)httpData;
                        ByteArrayInputStream in = new ByteArrayInputStream(at.getValue().getBytes(StandardCharsets.UTF_8));
                        Object fieldValue = context.readEntity(in, fieldFiller.getFieldType(), MediaType.valueOf((String)fieldFiller.getMediaType()), context.getMethodDeclaredAnnotationsSafe(), responseContext.getHeaders());
                        if (fieldValue == null) continue;
                        fieldFiller.set(result, fieldValue);
                        continue;
                    }
                    if (httpData instanceof FileUpload) {
                        FileUpload fu = (FileUpload)httpData;
                        fieldFiller.set(result, new FileDownloadImpl(fu));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported multipart message element type. Expected FileAttribute or Attribute, got: " + String.valueOf(httpData.getClass()));
                }
            } else {
                Class rawType = context.getResponseType().getRawType();
                if (context.isFileDownload()) {
                    if (File.class.equals((Object)rawType)) {
                        builder.entity(new File(context.getTmpFilePath()));
                    } else if (Path.class.equals((Object)rawType)) {
                        builder.entity(Paths.get(context.getTmpFilePath(), new String[0]));
                    } else {
                        throw new IllegalStateException("Unhandled type: " + String.valueOf(rawType));
                    }
                    context.clearTmpFilePath();
                } else if (!Void.TYPE.equals(rawType)) {
                    Object entity = context.readEntity(entityStream, context.getResponseType(), responseContext.getMediaType(), context.getMethodDeclaredAnnotationsSafe(), responseContext.getHeaders());
                    if (entity != null) {
                        builder.entity(entity);
                    }
                    if (entity != null && !(entity instanceof InputStream)) {
                        entityStream.close();
                    }
                }
            }
        } else {
            builder.entityStream(entityStream);
        }
        return builder.build();
    }
}

