/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.ProxyOptions;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.interceptors.ClientGZIPDecodingInterceptor;
import org.jboss.resteasy.reactive.client.logging.DefaultClientLogger;
import org.jboss.resteasy.reactive.client.spi.ClientContextResolver;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.MultiQueryParamMode;

public class ClientBuilderImpl
extends ClientBuilder {
    private static final Logger log = Logger.getLogger(ClientBuilderImpl.class);
    private static final ClientContextResolver CLIENT_CONTEXT_RESOLVER = ClientContextResolver.getInstance();
    private static final char[] EMPTY_CHAR_ARARAY = new char[0];
    public static final String PIPE = Pattern.quote("|");
    private ConfigurationImpl configuration;
    private HostnameVerifier hostnameVerifier;
    private KeyStore keyStore;
    private char[] keystorePassword;
    private SSLContext sslContext;
    private KeyStore trustStore;
    private char[] trustStorePassword;
    private boolean http2;
    private boolean alpn;
    private String proxyHost;
    private int proxyPort;
    private String proxyPassword;
    private String proxyUser;
    private String nonProxyHosts;
    private boolean followRedirects;
    private boolean trustAll;
    private boolean verifyHost = true;
    private LoggingScope loggingScope;
    private Integer loggingBodySize = 100;
    private MultiQueryParamMode multiQueryParamMode;
    private ClientLogger clientLogger = new DefaultClientLogger();
    private String userAgent = "Resteasy Reactive Client";
    private boolean enableCompression;

    public ClientBuilderImpl() {
        this.configuration = new ConfigurationImpl(RuntimeType.CLIENT);
    }

    public ClientBuilder withConfig(Configuration config) {
        this.configuration = new ConfigurationImpl(config);
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        throw new UnsupportedOperationException("Specifying SSLContext is not supported at the moment");
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.keystorePassword = password;
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        return this.trustStore(trustStore, null);
    }

    public ClientBuilder trustStore(KeyStore trustStore, char[] password) {
        this.trustStore = trustStore;
        this.trustStorePassword = password;
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        throw new UnsupportedOperationException("Specifying HostnameVerifier is not supported at the moment");
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        return this;
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return this;
    }

    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.configuration.property("io.quarkus.rest.client.connect-timeout", (Object)((int)unit.toMillis(timeout)));
        return this;
    }

    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.configuration.property("io.quarkus.rest.client.read-timeout", (Object)unit.toMillis(timeout));
        return this;
    }

    public ClientBuilder http2(boolean http2) {
        this.http2 = http2;
        return this;
    }

    public ClientBuilder alpn(boolean alpn) {
        this.alpn = alpn;
        return this;
    }

    public ClientBuilder proxy(String proxyHost, int proxyPort) {
        this.proxyPort = proxyPort;
        this.proxyHost = proxyHost;
        return this;
    }

    public ClientBuilder proxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ClientBuilder proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public ClientBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public ClientBuilder multiQueryParamMode(MultiQueryParamMode multiQueryParamMode) {
        this.multiQueryParamMode = multiQueryParamMode;
        return this;
    }

    public ClientBuilder loggingScope(LoggingScope loggingScope) {
        this.loggingScope = loggingScope;
        return this;
    }

    public ClientBuilder loggingBodySize(Integer loggingBodySize) {
        this.loggingBodySize = loggingBodySize;
        return this;
    }

    public ClientBuilder clientLogger(ClientLogger clientLogger) {
        this.clientLogger = clientLogger;
        return this;
    }

    public ClientBuilder enableCompression() {
        this.enableCompression = true;
        return this;
    }

    public ClientImpl build() {
        HttpClientOptions options = Optional.ofNullable((HttpClientOptions)this.configuration.getFromContext(HttpClientOptions.class)).orElseGet(HttpClientOptions::new);
        if (this.http2) {
            options.setProtocolVersion(HttpVersion.HTTP_2);
        }
        if (this.http2 || this.alpn) {
            options.setUseAlpn(true);
            options.setAlpnVersions(List.of(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
        }
        options.setVerifyHost(this.verifyHost);
        if (this.trustAll) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        }
        char[] effectiveTrustStorePassword = this.trustStorePassword == null ? EMPTY_CHAR_ARARAY : this.trustStorePassword;
        Buffer keyStore = this.asBuffer(this.keyStore, this.keystorePassword);
        Buffer trustStore = this.asBuffer(this.trustStore, effectiveTrustStorePassword);
        if (keyStore != null || trustStore != null) {
            JksOptions jks;
            options = options.setSsl(true);
            if (keyStore != null) {
                jks = new JksOptions();
                jks.setValue(keyStore);
                jks.setPassword(new String(this.keystorePassword));
                options = options.setKeyStoreOptions(jks);
            }
            if (trustStore != null) {
                jks = new JksOptions();
                jks.setValue(trustStore);
                jks.setPassword(new String(effectiveTrustStorePassword));
                options.setTrustStoreOptions(jks);
            }
        }
        if (this.proxyHost != null) {
            if (!"none".equals(this.proxyHost)) {
                ProxyOptions proxyOptions = new ProxyOptions().setHost(this.proxyHost).setPort(this.proxyPort);
                if (this.proxyPassword != null && !this.proxyPassword.isBlank()) {
                    proxyOptions.setPassword(this.proxyPassword);
                }
                if (this.proxyUser != null && !this.proxyUser.isBlank()) {
                    proxyOptions.setUsername(this.proxyUser);
                }
                options.setProxyOptions(proxyOptions);
                this.configureNonProxyHosts(options, this.nonProxyHosts);
            }
        } else {
            String proxyHost = options.isSsl() ? System.getProperty("https.proxyHost", "none") : System.getProperty("http.proxyHost", "none");
            String proxyPortAsString = options.isSsl() ? System.getProperty("https.proxyPort", "443") : System.getProperty("http.proxyPort", "80");
            String nonProxyHosts = options.isSsl() ? System.getProperty("https.nonProxyHosts", "localhost|127.*|[::1]") : System.getProperty("http.nonProxyHosts", "localhost|127.*|[::1]");
            int proxyPort = Integer.parseInt(proxyPortAsString);
            if (!"none".equals(proxyHost)) {
                ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost).setPort(proxyPort);
                String string = this.proxyUser = options.isSsl() ? System.getProperty("https.proxyUser") : System.getProperty("http.proxyUser");
                if (this.proxyUser != null && !this.proxyUser.isBlank()) {
                    proxyOptions.setUsername(this.proxyUser);
                }
                String string2 = this.proxyPassword = options.isSsl() ? System.getProperty("https.proxyPassword") : System.getProperty("http.proxyPassword");
                if (this.proxyPassword != null && !this.proxyPassword.isBlank()) {
                    proxyOptions.setPassword(this.proxyPassword);
                }
                options.setProxyOptions(proxyOptions);
                if (nonProxyHosts != null) {
                    this.configureNonProxyHosts(options, nonProxyHosts);
                }
            }
        }
        if (this.enableCompression) {
            this.configuration.register(ClientGZIPDecodingInterceptor.class);
        }
        this.clientLogger.setBodySize(this.loggingBodySize);
        return new ClientImpl(options, this.configuration, CLIENT_CONTEXT_RESOLVER.resolve(Thread.currentThread().getContextClassLoader()), this.hostnameVerifier, this.sslContext, this.followRedirects, this.multiQueryParamMode, this.loggingScope, this.clientLogger, this.userAgent);
    }

    private void configureNonProxyHosts(HttpClientOptions options, String nonProxyHosts) {
        if (nonProxyHosts != null) {
            for (String host : nonProxyHosts.split(PIPE)) {
                if (host.isBlank()) continue;
                options.addNonProxyHost(host);
            }
        }
    }

    private Buffer asBuffer(KeyStore keyStore, char[] password) {
        if (keyStore != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                keyStore.store(out, password);
                return Buffer.buffer((byte[])out.toByteArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                log.error((Object)"Failed to translate keystore to vert.x keystore", (Throwable)e);
            }
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ClientBuilder property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass) {
        this.configuration.register(componentClass);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, int priority) {
        this.configuration.register(componentClass, priority);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component) {
        this.configuration.register(component);
        return this;
    }

    public ClientBuilderImpl register(Object component, int priority) {
        this.configuration.register(component, priority);
        return this;
    }

    public ClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.configuration.register(component, contracts);
        return this;
    }

    public ClientBuilderImpl registerMessageBodyReader(MessageBodyReader<?> reader, Class<?> handledType, List<String> consumes, boolean builtin, Integer priority) {
        this.configuration.registerMessageBodyReader(reader, handledType, consumes, RuntimeType.CLIENT, builtin, priority);
        return this;
    }

    public ClientBuilderImpl registerMessageBodyWriter(MessageBodyWriter<?> writer, Class<?> handledType, List<String> consumes, boolean builtin, Integer priority) {
        this.configuration.registerMessageBodyWriter(writer, handledType, consumes, RuntimeType.CLIENT, builtin, priority);
        return this;
    }

    public ClientBuilderImpl trustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public ClientBuilderImpl verifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public ClientBuilderImpl setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ClientBuilderImpl nonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }
}

