/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.ByteArrayInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.InvocationBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.SseEventSourceImpl;

public class MultiInvoker
extends AbstractRxInvoker<Multi<?>> {
    private final InvocationBuilderImpl invocationBuilder;

    public MultiInvoker(InvocationBuilderImpl target) {
        this.invocationBuilder = target;
    }

    @Override
    public <R> Multi<R> get(Class<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> get(GenericType<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> method(String name, Entity<?> entity, GenericType<R> responseType) {
        AsyncInvokerImpl invoker = (AsyncInvokerImpl)this.invocationBuilder.rx();
        return Multi.createFrom().emitter(emitter -> {
            MultiRequest multiRequest = new MultiRequest(emitter);
            RestClientRequestContext restClientRequestContext = invoker.performRequestInternal(name, entity, responseType, false);
            restClientRequestContext.getResult().handle((response, connectionError) -> {
                if (connectionError != null) {
                    emitter.fail(connectionError);
                } else {
                    HttpClientResponse vertxResponse = restClientRequestContext.getVertxClientResponse();
                    if (!emitter.isCancelled()) {
                        if (response.getStatus() == 200 && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(response.getMediaType())) {
                            this.registerForSse(multiRequest, responseType, (Response)response, vertxResponse);
                        } else {
                            this.registerForChunks(multiRequest, restClientRequestContext, responseType, (Response)response, vertxResponse);
                        }
                        vertxResponse.resume();
                    } else {
                        vertxResponse.request().connection().close();
                    }
                }
                return null;
            });
        });
    }

    private <R> void registerForSse(MultiRequest<? super R> multiRequest, GenericType<R> responseType, Response response, HttpClientResponse vertxResponse) {
        SseEventSourceImpl sseSource = new SseEventSourceImpl(this.invocationBuilder.getTarget(), this.invocationBuilder, Integer.MAX_VALUE, TimeUnit.SECONDS);
        sseSource.register(event -> multiRequest.emitter.emit(event.readData(responseType)), error -> multiRequest.emitter.fail(error), () -> multiRequest.emitter.complete());
        multiRequest.onCancel(() -> sseSource.close());
        sseSource.registerAfterRequest(vertxResponse);
    }

    private <R> void registerForChunks(final MultiRequest<? super R> multiRequest, final RestClientRequestContext restClientRequestContext, final GenericType<R> responseType, final Response response, HttpClientResponse vertxClientResponse) {
        vertxClientResponse.exceptionHandler(t -> {
            if (t != ConnectionBase.CLOSED_EXCEPTION) {
                multiRequest.emitter.fail(t);
            }
        });
        vertxClientResponse.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer.getBytes());
                    Object item = restClientRequestContext.readEntity(in, responseType, response.getMediaType(), (MultivaluedMap<String, Object>)response.getMetadata());
                    multiRequest.emitter.emit(item);
                }
                catch (Throwable t) {
                    multiRequest.emitter.fail(t);
                }
            }
        });
        vertxClientResponse.endHandler(v -> multiRequest.emitter.complete());
        multiRequest.onCancel(() -> vertxClientResponse.request().connection().close());
    }

    static class MultiRequest<R> {
        private final AtomicReference<Runnable> onCancel = new AtomicReference();
        private final MultiEmitter<? super R> emitter;
        private static final Runnable CLEARED = () -> {};

        public MultiRequest(MultiEmitter<? super R> emitter) {
            this.emitter = emitter;
            emitter.onTermination(() -> {
                if (emitter.isCancelled()) {
                    this.cancel();
                }
            });
        }

        public boolean isCancelled() {
            return this.onCancel.get() == CLEARED;
        }

        private void cancel() {
            Runnable action = this.onCancel.getAndSet(CLEARED);
            if (action != null && action != CLEARED) {
                action.run();
            }
        }

        public void onCancel(Runnable onCancel) {
            if (!this.onCancel.compareAndSet(null, onCancel)) {
                if (this.onCancel.get() == CLEARED) {
                    if (onCancel != null) {
                        onCancel.run();
                    }
                } else {
                    throw new IllegalArgumentException("onCancel was already called");
                }
            }
        }
    }
}

