/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent;

import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.debug.DebuggerState;
import io.quarkus.qute.debug.DebuggerStoppedException;
import io.quarkus.qute.debug.StoppedEvent;
import io.quarkus.qute.debug.ThreadEvent;
import io.quarkus.qute.debug.agent.DebuggeeAgent;
import io.quarkus.qute.debug.agent.breakpoints.RemoteBreakpoint;
import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import io.quarkus.qute.debug.agent.frames.SectionFrameGroup;
import io.quarkus.qute.trace.ResolveEvent;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.lsp4j.debug.Thread;

public class RemoteThread
extends Thread {
    public static final Thread[] EMPTY_THREAD = new Thread[0];
    private static final Predicate<TemplateNode> TRUE_CONDITION = node -> true;
    private static final Predicate<TemplateNode> EXPRESSION_CONDITION = node -> !node.isText();
    private transient DebuggerState state;
    private final transient Object lock = new Object();
    private final transient LinkedList<RemoteStackFrame> frames = new LinkedList();
    private final transient LinkedList<SectionFrameGroup> sectionFrameStack = new LinkedList();
    private final transient DebuggeeAgent agent;
    private transient Predicate<TemplateNode> stopCondition;
    private transient Callable<CompletableFuture<Object>> pendingTask;
    private transient CompletableFuture<Object> taskResult;

    public RemoteThread(java.lang.Thread thread, DebuggeeAgent agent) {
        super.setId((int)thread.getId());
        super.setName(thread.getName());
        this.agent = agent;
        this.state = DebuggerState.INITIALIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case STOPPED: {
                    throw new DebuggerStoppedException();
                }
                case RUNNING: {
                    this.stopCondition = TRUE_CONDITION;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case STOPPED: {
                    throw new DebuggerStoppedException();
                }
            }
            if (this.state != DebuggerState.SUSPENDED) {
                throw new IllegalStateException();
            }
            this.state = DebuggerState.RUNNING;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == DebuggerState.STOPPED;
        }
    }

    public void onBeforeResolve(ResolveEvent event) {
        SectionFrameGroup sectionGroup;
        if (this.isStopped()) {
            return;
        }
        Engine engine = event.getEngine();
        RemoteStackFrame frame = new RemoteStackFrame(event, this.getCurrentFrame(), this.agent.getSourceTemplateRegistry(engine), this.agent.getVariablesRegistry(), this);
        SectionFrameGroup sectionFrameGroup = sectionGroup = this.sectionFrameStack.isEmpty() ? null : this.sectionFrameStack.getFirst();
        if (sectionGroup != null) {
            sectionGroup.detachFramesIfIndexChanged(event.getContext().getData(), this.frames);
            sectionGroup.addFrame(frame);
        }
        if (event.getTemplateNode().isSection()) {
            this.sectionFrameStack.addFirst(new SectionFrameGroup(event.getTemplateNode().asSection().getHelper()));
        }
        this.frames.addFirst(frame);
        String templateId = frame.getTemplateId();
        URI sourceUri = frame.getTemplateUri();
        RemoteStackFrame previous = frame.getPrevious();
        if (this.stopCondition != null && this.stopCondition.test(event.getTemplateNode())) {
            this.suspendAndWait(StoppedEvent.StoppedReason.STEP);
        } else {
            int lineNumber = frame.getLine();
            RemoteBreakpoint breakpoint = this.agent.getBreakpoint(sourceUri, templateId, lineNumber, engine);
            if (breakpoint != null && (previous == null || !previous.getTemplateId().equals(templateId) || previous.getLine() != lineNumber || event.getTemplateNode().isExpression()) && breakpoint.checkCondition(frame)) {
                this.suspendAndWait(StoppedEvent.StoppedReason.BREAKPOINT);
            }
        }
    }

    public void onAfterResolve(ResolveEvent event) {
        if (this.isStopped()) {
            return;
        }
        if (event.getTemplateNode().isSection()) {
            SectionFrameGroup sectionGroup = this.sectionFrameStack.removeFirst();
            sectionGroup.detachFrames(this.frames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAndWait(StoppedEvent.StoppedReason reason) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.state = DebuggerState.SUSPENDED;
                this.lock.notifyAll();
                this.stopCondition = null;
                StoppedEvent e = new StoppedEvent(this.getId(), reason);
                this.agent.fireStoppedEvent(e);
                while (this.state == DebuggerState.SUSPENDED) {
                    if (this.pendingTask != null) {
                        try {
                            this.taskResult = this.pendingTask.call();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            this.pendingTask = null;
                            this.lock.notifyAll();
                        }
                    }
                    this.lock.wait(50L);
                }
            }
        }
        catch (InterruptedException e) {
            java.lang.Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> evaluateInRenderThread(Callable<CompletableFuture<Object>> action) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != DebuggerState.SUSPENDED) {
                throw new IllegalStateException("Thread not suspended");
            }
            if (this.pendingTask != null) {
                throw new IllegalStateException("A task is already pending");
            }
            this.pendingTask = action;
            this.taskResult = null;
            this.lock.notifyAll();
            while (this.pendingTask != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    java.lang.Thread.currentThread().interrupt();
                }
            }
            return this.taskResult;
        }
    }

    private RemoteStackFrame getCurrentFrame() {
        return !this.frames.isEmpty() ? this.frames.getFirst() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.lock;
        synchronized (object) {
            this.state = DebuggerState.STOPPED;
            this.lock.notifyAll();
        }
    }

    public void stepIn() {
        this.stopCondition = TRUE_CONDITION;
        this.resume();
    }

    public void stepOut() {
        this.resume();
    }

    public void stepOver() {
        int frameSize = this.frames.size();
        this.stopCondition = node -> this.frames.size() <= frameSize;
        this.resume();
    }

    public void next() {
        this.stopCondition = EXPRESSION_CONDITION;
        this.resume();
    }

    public List<RemoteStackFrame> getStackFrames() {
        return this.frames;
    }

    public RemoteStackFrame getStackFrame(int frameId) {
        for (RemoteStackFrame frame : this.frames) {
            if (frameId != frame.getId()) continue;
            return frame;
        }
        return null;
    }

    public void start() {
        this.frames.clear();
        this.agent.fireThreadEvent(new ThreadEvent(this.getId(), ThreadEvent.ThreadStatus.STARTED));
    }

    public void exit() {
        this.agent.fireThreadEvent(new ThreadEvent(this.getId(), ThreadEvent.ThreadStatus.EXITED));
    }
}

