/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.source;

import java.net.URI;
import org.eclipse.lsp4j.debug.Source;

public abstract class RemoteSource
extends Source {
    private final transient URI uri;
    private final transient String templateId;

    public RemoteSource(URI uri, String templateId) {
        this.uri = uri;
        this.templateId = templateId;
        super.setName(uri != null ? this.computeName(uri) : templateId);
    }

    protected String computeName(URI uri) {
        return RemoteSource.getFileNameFallback(uri.toString());
    }

    public URI getUri() {
        return this.uri;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    private static String getFileNameFallback(String s) {
        int idx = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        if (idx != -1 && idx < s.length() - 1) {
            return s.substring(idx + 1);
        }
        return s;
    }
}

