/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.resolvers;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverCollector;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;

public class ReflectionValueResolverCollector
implements ValueResolverCollector {
    @Override
    public boolean isApplicable(ValueResolver valueResolver, EvalContext evalContext) {
        return true;
    }

    @Override
    public void collect(ValueResolver valueResolver, ValueResolverContext context) {
        Class<?> clazz = context.getBase().getClass();
        ArrayList hierarchy = new ArrayList();
        Collections.addAll(hierarchy, clazz.getInterfaces());
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Collections.addAll(hierarchy, superClass.getInterfaces());
        }
        hierarchy.add(clazz);
        for (Class clazz2 : hierarchy) {
            if (context.isCollectProperty()) {
                for (AccessibleObject accessibleObject : clazz.getFields()) {
                    if (!ReflectionValueResolverCollector.isFieldCandidate((Field)accessibleObject)) continue;
                    context.addProperty((Field)accessibleObject);
                }
            }
            if (!context.isCollectMethod()) continue;
            for (AccessibleObject accessibleObject : clazz2.getMethods()) {
                if (!ReflectionValueResolverCollector.isMethodCandidate((Method)accessibleObject)) continue;
                context.addMethod((Method)accessibleObject);
            }
        }
    }

    public static boolean isFieldCandidate(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    private static boolean isMethodCandidate(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.getReturnType().equals(Void.TYPE) && !method.isBridge() && !Object.class.equals(method.getDeclaringClass());
    }
}

