/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.frames;

import io.quarkus.qute.LoopSectionHelper;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import java.util.LinkedList;

public class SectionFrameGroup {
    private static final String ITERATION_ELEMENT_CLASS_NAME = "IterationElement";
    private final LinkedList<RemoteStackFrame> frames = new LinkedList();
    private final String metadataIndex;
    private int index;

    public SectionFrameGroup(SectionHelper sectionHelper) {
        String string;
        if (sectionHelper instanceof LoopSectionHelper) {
            LoopSectionHelper loopSectionHelper = (LoopSectionHelper)sectionHelper;
            string = loopSectionHelper.getMetadataPrefix() + "index";
        } else {
            string = null;
        }
        this.metadataIndex = string;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int newIndex) {
        this.index = newIndex;
        this.frames.clear();
    }

    public void addFrame(RemoteStackFrame frame) {
        this.frames.addFirst(frame);
    }

    public void detachFrames(LinkedList<RemoteStackFrame> threadFrames) {
        threadFrames.removeAll(this.frames);
    }

    public void detachFramesIfIndexChanged(Object data, LinkedList<RemoteStackFrame> threadFrames) {
        if (this.metadataIndex != null && data instanceof Mapper) {
            Mapper mapper = (Mapper)data;
            if (ITERATION_ELEMENT_CLASS_NAME.equals(data.getClass().getSimpleName())) {
                try {
                    Integer currentIndex;
                    Object result = mapper.getAsync(this.metadataIndex).toCompletableFuture().getNow(null);
                    if (result instanceof Integer && (currentIndex = (Integer)result) != this.index) {
                        this.detachFrames(threadFrames);
                        this.setIndex(currentIndex);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

