/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.frames;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.debug.agent.DebuggerEvalContext;
import io.quarkus.qute.debug.agent.RemoteThread;
import io.quarkus.qute.debug.agent.evaluations.ConditionalExpressionHelper;
import io.quarkus.qute.debug.agent.scopes.GlobalsScope;
import io.quarkus.qute.debug.agent.scopes.LocalsScope;
import io.quarkus.qute.debug.agent.scopes.NamespaceResolversScope;
import io.quarkus.qute.debug.agent.scopes.RemoteScope;
import io.quarkus.qute.debug.agent.source.RemoteSource;
import io.quarkus.qute.debug.agent.source.SourceTemplateRegistry;
import io.quarkus.qute.debug.agent.variables.VariablesRegistry;
import io.quarkus.qute.trace.ResolveEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.StackFrame;

public class RemoteStackFrame
extends StackFrame {
    public static final StackFrame[] EMPTY_STACK_FRAMES = new StackFrame[0];
    private static final AtomicInteger frameIdCounter = new AtomicInteger();
    private final transient RemoteStackFrame previousFrame;
    private final transient String templateId;
    private final transient VariablesRegistry variablesRegistry;
    private transient Collection<RemoteScope> scopes;
    private final transient ResolveEvent event;
    private final transient RemoteThread remoteThread;

    public RemoteStackFrame(ResolveEvent event, RemoteStackFrame previousFrame, SourceTemplateRegistry sourceTemplateRegistry, VariablesRegistry variablesRegistry, RemoteThread remoteThread) {
        this.event = event;
        this.previousFrame = previousFrame;
        this.variablesRegistry = variablesRegistry;
        this.remoteThread = remoteThread;
        int id = frameIdCounter.incrementAndGet();
        int line = event.getTemplateNode().getOrigin().getLine();
        super.setId(id);
        super.setName(event.getTemplateNode().toString());
        super.setLine(line);
        this.templateId = event.getTemplateNode().getOrigin().getTemplateId();
        super.setSource((Source)sourceTemplateRegistry.getSource(this.templateId, previousFrame != null ? previousFrame.getSource() : null));
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public URI getTemplateUri() {
        RemoteSource source = this.getSource();
        return source != null ? source.getUri() : null;
    }

    public RemoteSource getSource() {
        return (RemoteSource)super.getSource();
    }

    public RemoteStackFrame getPrevious() {
        return this.previousFrame;
    }

    public Collection<RemoteScope> getScopes() {
        if (this.scopes == null) {
            this.scopes = this.createScopes();
        }
        return this.scopes;
    }

    private Collection<RemoteScope> createScopes() {
        ArrayList<RemoteScope> scopes = new ArrayList<RemoteScope>();
        scopes.add(new LocalsScope(this.event.getContext(), this, this.variablesRegistry));
        scopes.add(new GlobalsScope(this.event.getContext(), this, this.variablesRegistry));
        scopes.add(new NamespaceResolversScope(this.event.getEngine(), this, this.variablesRegistry));
        return scopes;
    }

    public CompletableFuture<Object> evaluate(String expression) {
        if (RemoteStackFrame.isConditionExpression(expression)) {
            TemplateNode ifNode;
            try {
                ifNode = ConditionalExpressionHelper.parseCondition(expression);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
            return this.evaluateConditionInRenderThread(ifNode, false);
        }
        return this.evaluateExpressionInRenderThread(expression);
    }

    private CompletableFuture<Object> evaluateExpressionInRenderThread(String expression) {
        return this.remoteThread.evaluateInRenderThread(() -> {
            try {
                return this.event.getContext().evaluate(expression).toCompletableFuture();
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    private static boolean isConditionExpression(String expression) {
        return expression.contains("!") || expression.contains(">") || expression.contains("==") || expression.contains("<") || expression.contains("&&") || expression.contains("||") || expression.contains(" eq") || expression.contains(" ne") || expression.contains(" gt") || expression.contains(" lt") || expression.contains(" ge") || expression.contains(" le") || expression.contains(" and") || expression.contains(" or") || expression.contains(" is");
    }

    public CompletableFuture<Object> evaluateConditionInRenderThread(TemplateNode ifNode, boolean ignoreError) {
        return this.remoteThread.evaluateInRenderThread(() -> this.evaluateCondition(ifNode, ignoreError));
    }

    public CompletableFuture<Object> evaluateCondition(TemplateNode ifNode, boolean ignoreError) {
        try {
            return ifNode.resolve(this.event.getContext()).toCompletableFuture().handle((result, error) -> {
                if (error != null) {
                    if (ignoreError) {
                        return false;
                    }
                    throw new CompletionException((Throwable)error);
                }
                TextNode textNode = (TextNode)result;
                return Boolean.parseBoolean(textNode.getValue());
            });
        }
        catch (Throwable e) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
    }

    public Engine getEngine() {
        return this.event.getEngine();
    }

    public ResolveEvent getEvent() {
        return this.event;
    }

    public EvalContext createEvalContext(Object base) {
        return new DebuggerEvalContext(base, this);
    }
}

