/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.breakpoints;

import io.quarkus.qute.debug.agent.breakpoints.RemoteBreakpoint;
import io.quarkus.qute.debug.agent.source.RemoteSource;
import io.quarkus.qute.debug.agent.source.SourceTemplateRegistry;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;

public class BreakpointsRegistry {
    private final Map<URI, Map<Integer, RemoteBreakpoint>> breakpoints = new ConcurrentHashMap<URI, Map<Integer, RemoteBreakpoint>>();

    public Breakpoint[] setBreakpoints(SourceBreakpoint[] sourceBreakpoints, Source source) {
        Map templateBreakpoints;
        URI uri = SourceTemplateRegistry.toUri(source);
        Map map = templateBreakpoints = uri != null ? this.breakpoints.computeIfAbsent(uri, k -> new ConcurrentHashMap()) : null;
        if (templateBreakpoints != null) {
            templateBreakpoints.clear();
        }
        Breakpoint[] result = new Breakpoint[sourceBreakpoints.length];
        for (int i = 0; i < sourceBreakpoints.length; ++i) {
            SourceBreakpoint sourceBreakpoint = sourceBreakpoints[i];
            int line = sourceBreakpoint.getLine();
            String condition = sourceBreakpoint.getCondition();
            RemoteBreakpoint breakpoint = new RemoteBreakpoint(source, line, condition);
            if (templateBreakpoints != null) {
                templateBreakpoints.put(line, breakpoint);
                breakpoint.setVerified(true);
            } else {
                breakpoint.setVerified(false);
            }
            result[i] = breakpoint;
        }
        return result;
    }

    public Set<URI> getSourceUris() {
        return this.breakpoints.keySet();
    }

    public RemoteBreakpoint resolveBreakpoint(URI sourceUri, String templateId, int line, SourceTemplateRegistry sourceTemplateRegistry) {
        Map<Integer, RemoteBreakpoint> templateBreakpoints = this.findTemplateBreakpoints(sourceUri, templateId, sourceTemplateRegistry);
        return templateBreakpoints != null ? templateBreakpoints.get(line) : null;
    }

    private Map<Integer, RemoteBreakpoint> findTemplateBreakpoints(URI sourceUri, String templateId, SourceTemplateRegistry sourceTemplateRegistry) {
        if (sourceUri != null) {
            return this.breakpoints.get(sourceUri);
        }
        RemoteSource source = sourceTemplateRegistry.getSource(templateId, null);
        URI uri = source != null ? source.getUri() : null;
        return uri != null ? this.breakpoints.get(uri) : null;
    }

    public void reset() {
        this.breakpoints.clear();
    }
}

